/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.servlet;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.wss.fm.FreeMarkerRenderer;
import org.nuxeo.wss.servlet.WSSStaticResponse;

public class WSSResponse
extends WSSStaticResponse {
    protected boolean bufferizeRendering = true;
    protected static final int BUFFER_SIZE = 10240;
    protected Map<String, Object> renderingContext = new HashMap<String, Object>();
    protected String renderingTemplateName = null;

    public WSSResponse(HttpServletResponse httpResponse) {
        super(httpResponse);
    }

    protected void processRender() throws Exception {
        if (this.renderingTemplateName != null) {
            BufferedWriter writer = null;
            ByteArrayOutputStream bufferedOs = null;
            if (this.bufferizeRendering) {
                bufferedOs = new ByteArrayOutputStream();
                writer = new BufferedWriter(new OutputStreamWriter(bufferedOs));
            } else {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)this.getHttpResponse().getOutputStream()));
            }
            FreeMarkerRenderer.instance().render(this.renderingTemplateName, this.renderingContext, writer);
            ((Writer)writer).flush();
            if (this.bufferizeRendering && this.additionnalStream != null) {
                int read;
                byte[] buffer = new byte[10240];
                while ((read = this.additionnalStream.read(buffer)) != -1) {
                    bufferedOs.write(buffer, 0, read);
                    bufferedOs.flush();
                }
            }
            ((Writer)writer).close();
            if (this.bufferizeRendering) {
                int size = bufferedOs.size();
                this.getHttpResponse().setContentLength(size);
                ServletOutputStream out = this.getHttpResponse().getOutputStream();
                out.write(bufferedOs.toByteArray());
                out.close();
            }
        }
    }

    public Map<String, Object> getRenderingContext() {
        return this.renderingContext;
    }

    public void setRenderingContext(Map<String, Object> renderingContext) {
        this.renderingContext = renderingContext;
    }

    public String getRenderingTemplateName() {
        return this.renderingTemplateName;
    }

    public void setRenderingTemplateName(String renderingTemplateName) {
        this.renderingTemplateName = renderingTemplateName;
    }

    public void addRenderingParameter(String name, Object value) {
        this.renderingContext.put(name, value);
    }
}

