/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.url;

import org.nuxeo.wss.WSSConfig;
import org.nuxeo.wss.servlet.WSSRequest;
import org.nuxeo.wss.url.WSSUrlMapping;

public class WSSUrlMapper {
    public static String getLocationFromFullUrl(WSSRequest request, String url) {
        if (url == null) {
            return null;
        }
        if (url.startsWith("[")) {
            url = url.substring(1, url.length() - 2);
        }
        String location = url.replace(request.getBaseUrl(), "");
        return location;
    }

    public static WSSUrlMapping getWebMapping(WSSRequest request, String location) {
        String siteUrl = "/";
        String resourceUrl = location;
        if (location.startsWith("http")) {
            siteUrl = request.getBaseUrl();
            resourceUrl = location.replace(siteUrl, "");
        } else {
            String ctxPath = WSSUrlMapper.getFirstSegment(WSSConfig.instance().getContextPath());
            String resourcePath = WSSUrlMapper.getFirstSegment(resourceUrl);
            if (ctxPath != null && ctxPath.equals(resourcePath)) {
                resourceUrl = resourceUrl.replace(resourcePath, "");
                siteUrl = resourcePath;
            }
            if (!siteUrl.startsWith("/")) {
                siteUrl = "/" + siteUrl;
            }
            while (resourceUrl.startsWith("/")) {
                resourceUrl = resourceUrl.substring(1);
            }
        }
        return new WSSUrlMapping(siteUrl, resourceUrl);
    }

    public static String getUrlWithSitePath(WSSRequest request, String location) {
        String sitePath = request.getSitePath();
        if (sitePath != null && !"".equals(sitePath)) {
            String fullPath = sitePath;
            fullPath = location.startsWith("/") ? fullPath + location : fullPath + "/" + location;
            return fullPath;
        }
        return location;
    }

    private static String getCleanUrl(String location) {
        if ("".equals(location) || location == null) {
            return "/";
        }
        return location;
    }

    public static String getFirstSegment(String path) {
        if (path == null) {
            return null;
        }
        if (path.trim().equals("")) {
            return "";
        }
        String[] parts = path.split("/");
        if (!"".equals(parts[0].trim())) {
            return parts[0];
        }
        return parts[1];
    }
}

