/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.spi.dummy;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.wss.WSSException;
import org.nuxeo.wss.spi.AbstractWSSListItem;
import org.nuxeo.wss.spi.WSSListItem;
import org.nuxeo.wss.spi.dummy.DummyMemoryTree;

public class DummyWSSListItem
extends AbstractWSSListItem
implements WSSListItem {
    private static final Log log = LogFactory.getLog(DummyWSSListItem.class);
    protected String subPath;
    protected String description;
    protected InputStream stream;
    protected String name;
    protected String type;
    protected int size;
    protected String binaryResourcePath;
    protected byte[] byteArray;
    protected String uuid = null;
    protected Calendar creationDate;
    protected Calendar modificationDate;
    protected Calendar checkoutDate;
    protected String checkoutUser;

    public DummyWSSListItem(String name, String description, InputStream is) {
        this(name, description, null, is);
    }

    public DummyWSSListItem(String name, String description, String basePath, InputStream is) {
        this.name = name;
        this.description = description;
        this.creationDate = Calendar.getInstance();
        this.subPath = basePath != null ? (basePath.endsWith("/") ? basePath + name : basePath + "/" + name) : name;
        try {
            this.setStream(is, null);
        }
        catch (WSSException e) {
            log.error((Object)"Error processing stream", (Throwable)e);
        }
    }

    @Override
    public String getSubPath() {
        return this.subPath;
    }

    public void setSubPath(String subPath) {
        this.subPath = subPath;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
        this.update();
    }

    @Override
    public InputStream getStream() {
        if (this.stream == null && this.byteArray != null) {
            return new ByteArrayInputStream(this.byteArray);
        }
        if (this.stream == null && this.binaryResourcePath != null) {
            return DummyMemoryTree.class.getClassLoader().getResourceAsStream(this.binaryResourcePath);
        }
        return this.stream;
    }

    @Override
    public void setStream(InputStream stream, String fileName) throws WSSException {
        if (stream == null) {
            this.type = "folder";
        } else {
            this.type = "file";
            try {
                this.copyStreamToBA(stream);
            }
            catch (IOException e) {
                throw new WSSException("Error while transfering stream", e);
            }
        }
        this.update();
    }

    protected void update() {
        this.modificationDate = Calendar.getInstance();
    }

    protected void copyStreamToBA(InputStream is) throws IOException {
        byte[] tmp_buffer = new byte[524288];
        byte[] read_buffer = new byte[3];
        int i = 0;
        int idx = 0;
        while ((i = is.read(read_buffer)) > 0) {
            System.arraycopy(read_buffer, 0, tmp_buffer, idx, i);
            idx += i;
        }
        this.byteArray = new byte[idx];
        System.arraycopy(tmp_buffer, 0, this.byteArray, 0, idx);
        this.size = idx;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getEtag() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID().toString();
        }
        return this.uuid;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate.getTime();
    }

    @Override
    public Date getModificationDate() {
        if (this.modificationDate == null) {
            return this.getCreationDate();
        }
        return this.modificationDate.getTime();
    }

    public void setBinaryResourcePath(String binaryResourcePath) {
        this.binaryResourcePath = binaryResourcePath;
        this.type = "file";
    }

    @Override
    public String getLastModificator() {
        return "someone";
    }

    @Override
    public void checkOut(String userName) throws WSSException {
        if (this.checkoutUser != null && !this.checkoutUser.equals(userName)) {
            throw new WSSException("Document is already checkedout");
        }
        this.checkoutUser = userName;
    }

    @Override
    public void uncheckOut(String userName) throws WSSException {
        if (this.checkoutUser != null && !this.checkoutUser.equals(userName)) {
            throw new WSSException("Document is checkedout by another user");
        }
        this.checkoutUser = null;
    }

    @Override
    protected Date getCheckoutDate() {
        if (this.checkoutDate == null) {
            this.checkoutDate = Calendar.getInstance();
        }
        return this.checkoutDate.getTime();
    }

    @Override
    protected Date getCheckoutExpiryDate() {
        Calendar date = Calendar.getInstance();
        date.setTime(this.getCheckoutDate());
        date.add(12, 10);
        return date.getTime();
    }

    @Override
    public String getCheckoutUser() {
        return this.checkoutUser;
    }

    public void markAsSite() {
        this.isSiteItem = true;
    }

    @Override
    public String getAuthor() {
        return "me";
    }
}

