/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.groups.audit.seam;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.groups.audit.service.acl.excel.AclNameShortner;
import org.nuxeo.ecm.platform.groups.audit.service.acl.job.RunnableAclAudit;
import org.nuxeo.ecm.platform.groups.audit.service.acl.job.Work;
import org.nuxeo.ecm.platform.groups.audit.service.acl.job.publish.PublishAsDocument;
import org.nuxeo.ecm.platform.groups.audit.service.acl.job.publish.PublishByMail;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.runtime.api.Framework;

@Name(value="excelExportRightsAction")
@Scope(value=ScopeType.EVENT)
public class ExcelExportRightsActionBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ExcelExportRightsActionBean.class);
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected NavigationContext navigationContext;
    @In(create=true)
    protected DocumentsListsManager documentsListsManager;
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    @In(create=true, required=false)
    protected NuxeoPrincipal currentNuxeoPrincipal;
    protected static String OUTPUT_FILE_NAME = "permissions";
    protected static String OUTPUT_FILE_EXT = ".xls";
    private static final String WORK_NAME = "Permission Audit for ";
    protected Set<String> existingPermissions = new HashSet<String>();

    public ExcelExportRightsActionBean() {
        AclNameShortner names = new AclNameShortner();
        this.existingPermissions.addAll(names.getFullNames());
    }

    public String doGet() {
        try {
            this.buildAndDownload();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            this.facesMessages.add(StatusMessage.Severity.ERROR, "doGet error: " + e.getMessage(), new Object[0]);
        }
        return null;
    }

    public boolean accept() {
        return true;
    }

    protected List<DocumentModel> getCurrentlySelectedDocuments() {
        if (this.navigationContext.getCurrentDocument().isFolder()) {
            return this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        }
        return null;
    }

    public void buildAndDownload() throws ClientException, IOException {
        File tmpFile = File.createTempFile("rights", ".xls");
        tmpFile.deleteOnExit();
        this.buildAndSendByMail(tmpFile);
    }

    protected void buildAndDownload(final File tmpFile) throws ClientException {
        final FacesContext context = FacesContext.getCurrentInstance();
        DocumentModel auditRoot = this.navigationContext.getCurrentDocument();
        RunnableAclAudit todo = new RunnableAclAudit(this.documentManager, auditRoot, tmpFile){

            @Override
            public void onAuditDone() {
                ComponentUtils.downloadFile((FacesContext)context, (String)(OUTPUT_FILE_NAME + OUTPUT_FILE_EXT), (File)tmpFile);
            }
        };
        todo.run();
    }

    protected void buildAndSaveAsChildDocument(File tmpFile) throws ClientException {
        final DocumentModel auditRoot = this.navigationContext.getCurrentDocument();
        final String repository = this.documentManager.getRepositoryName();
        final String workName = WORK_NAME + auditRoot.getPathAsString();
        Work work = new Work(workName);
        new RunnableAclAudit(this.documentManager, auditRoot, work, tmpFile){

            @Override
            public void onAuditDone() {
                PublishAsDocument publisher = new PublishAsDocument(this.getOutputFile(), workName, repository, auditRoot);
                try {
                    publisher.publish();
                }
                catch (ClientException e) {
                    ExcelExportRightsActionBean.this.facesMessages.add(StatusMessage.Severity.ERROR, e.getMessage(), new Object[0]);
                    log.error((Object)e, (Throwable)e);
                }
            }
        };
        WorkManager wm = (WorkManager)Framework.getLocalService(WorkManager.class);
        wm.schedule((org.nuxeo.ecm.core.work.api.Work)work);
        String message = (String)this.resourcesAccessor.getMessages().get("message.audit.acl.started");
        this.facesMessages.add(StatusMessage.Severity.INFO, message, new Object[0]);
    }

    protected void buildAndSendByMail(File tmpFile) throws ClientException {
        DocumentModel auditRoot = this.navigationContext.getCurrentDocument();
        final String repository = this.documentManager.getRepositoryName();
        final String to = this.currentNuxeoPrincipal.getEmail();
        String defaultFrom = "noreply@nuxeo.com";
        String workName = WORK_NAME + auditRoot.getPathAsString();
        if (StringUtils.isBlank((String)to)) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, "Your email is missing from your profile.", new Object[0]);
            return;
        }
        Work work = new Work(workName);
        new RunnableAclAudit(this.documentManager, auditRoot, work, tmpFile){

            @Override
            public void onAuditDone() {
                FileBlob fb = new FileBlob(this.getOutputFile(), "application/xls");
                fb.setFilename(OUTPUT_FILE_NAME + OUTPUT_FILE_EXT);
                PublishByMail publisher = new PublishByMail(fb, to, "noreply@nuxeo.com", repository);
                try {
                    publisher.publish();
                }
                catch (ClientException e) {
                    log.error((Object)e, (Throwable)e);
                    ExcelExportRightsActionBean.this.facesMessages.add(StatusMessage.Severity.ERROR, e.getMessage(), new Object[0]);
                }
            }
        };
        WorkManager wm = (WorkManager)Framework.getLocalService(WorkManager.class);
        wm.schedule((org.nuxeo.ecm.core.work.api.Work)work);
        String message = (String)this.resourcesAccessor.getMessages().get("message.acl.audit.started");
        this.facesMessages.add(StatusMessage.Severity.INFO, message, new Object[0]);
    }

    public Set<String> getExistingPermissions() {
        return this.existingPermissions;
    }
}

