/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.groups.audit.service.acl.excel;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Set;

public class AclNameShortner {
    protected BiMap<String, String> mapping = HashBiMap.create();

    public AclNameShortner() {
        this.mapping.put((Object)"Everything", (Object)"A");
        this.mapping.put((Object)"Browse", (Object)"B");
        this.mapping.put((Object)"Read", (Object)"R");
        this.mapping.put((Object)"ReadChildren", (Object)"RC");
        this.mapping.put((Object)"ReadLifeCycle", (Object)"RL");
        this.mapping.put((Object)"ReadProperties", (Object)"RP");
        this.mapping.put((Object)"ReadSecurity", (Object)"RS");
        this.mapping.put((Object)"ReadVersion", (Object)"RV");
        this.mapping.put((Object)"ReadWrite", (Object)"RW");
        this.mapping.put((Object)"Write", (Object)"W");
        this.mapping.put((Object)"WriteLifeCycle", (Object)"WL");
        this.mapping.put((Object)"WriteProperties", (Object)"WP");
        this.mapping.put((Object)"WriteSecurity", (Object)"WS");
        this.mapping.put((Object)"WriteVersion", (Object)"WV");
        this.mapping.put((Object)"AddChildren", (Object)"AC");
        this.mapping.put((Object)"RemoveChildren", (Object)"DC");
        this.mapping.put((Object)"ManageWorkflows", (Object)"MW");
        this.mapping.put((Object)"ReviewParticipant", (Object)"VW");
        this.mapping.put((Object)"RestrictedRead", (Object)"RR");
        this.mapping.put((Object)"Unlock", (Object)"U");
        this.mapping.put((Object)"Version", (Object)"V");
        this.mapping.put((Object)"Remove", (Object)"RE");
    }

    public String getShortName(String permission) {
        if (!this.mapping.containsKey((Object)permission)) {
            throw new IllegalArgumentException("Unknown permission '" + permission + "'");
        }
        return (String)this.mapping.get((Object)permission);
    }

    public String getFullName(String shortname) {
        return (String)this.mapping.inverse().get((Object)shortname);
    }

    public void register(String permission, String shortname) {
        this.mapping.put((Object)permission, (Object)shortname);
    }

    public BiMap<String, String> getMapping() {
        return this.mapping;
    }

    public Set<String> getShortNames() {
        return this.getMapping().inverse().keySet();
    }

    public Set<String> getFullNames() {
        return this.getMapping().keySet();
    }
}

