/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.groups.audit.service.acl.excel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFAnchor;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.nuxeo.ecm.platform.groups.audit.service.acl.excel.ByteColor;
import org.nuxeo.ecm.platform.groups.audit.service.acl.excel.IExcelBuilder;

public class ExcelBuilder
implements IExcelBuilder {
    static Log log = LogFactory.getLog(ExcelBuilder.class);
    public static int MAX_COLUMN = 256;
    public static int MAX_ROW = 65536;
    public static int LAST_COLUMN = MAX_COLUMN - 1;
    public static int LAST_ROW = MAX_ROW - 1;
    public static boolean CRASH_ON_CELL_OVERFLOW = false;
    protected Type type;
    protected Workbook workbook;
    protected CreationHelper create;
    protected Drawing drawing;
    protected Font boldFont;
    protected int currentSheetId;
    protected Map<Integer, Sheet> sheets;

    public ExcelBuilder() {
        this(Type.XLS);
    }

    public ExcelBuilder(Type type) {
        this(type, "default");
    }

    public ExcelBuilder(Type type, String firstSheet) {
        this.type = type;
        if (Type.XLS.equals((Object)type)) {
            this.workbook = new HSSFWorkbook();
        } else if (Type.XLSX.equals((Object)type)) {
            this.workbook = new XSSFWorkbook();
        }
        this.sheets = new HashMap<Integer, Sheet>();
        this.create = this.workbook.getCreationHelper();
        this.currentSheetId = this.newSheet(0, "Repository");
        this.drawing = this.getCurrentSheet().createDrawingPatriarch();
        this.boldFont = this.workbook.createFont();
        this.boldFont.setBoldweight((short)700);
    }

    @Override
    public Workbook getWorkbook() {
        return this.workbook;
    }

    public HSSFWorkbook getHSSFWorkbook() {
        return (HSSFWorkbook)this.workbook;
    }

    @Override
    public Cell setCell(int row, int column, String content, CellStyle style) {
        if (!this.validateCellIndex(row, column, content)) {
            return null;
        }
        Cell cell = this.getOrCreateCell(row, column);
        cell.setCellValue(this.create.createRichTextString(content));
        if (style != null) {
            cell.setCellStyle(style);
        }
        return cell;
    }

    protected boolean validateCellIndex(int row, int column, String content) {
        if (row >= MAX_ROW) {
            String message = "max number of row (" + MAX_ROW + ") exceeded @ " + row + " by '" + content + "'";
            if (CRASH_ON_CELL_OVERFLOW) {
                throw new IllegalArgumentException(message);
            }
            log.warn((Object)message);
            return false;
        }
        if (column >= MAX_COLUMN) {
            String message = "max number of column (" + MAX_COLUMN + ") exceeded @ " + column + " by '" + content + "'";
            if (CRASH_ON_CELL_OVERFLOW) {
                throw new IllegalArgumentException(message);
            }
            log.warn((Object)message);
            return false;
        }
        return true;
    }

    @Override
    public Cell setCell(int row, int column, String content) {
        return this.setCell(row, column, content, null);
    }

    @Override
    public Sheet getCurrentSheet() {
        return this.sheets.get(this.getCurrentSheetId());
    }

    @Override
    public int getCurrentSheetId() {
        return this.currentSheetId;
    }

    @Override
    public void setCurrentSheetId(int s) {
        this.currentSheetId = s;
    }

    @Override
    public int newSheet(int index, String name) {
        Sheet s = this.workbook.createSheet(name);
        this.sheets.put(index, s);
        return index;
    }

    @Override
    public Collection<Sheet> getAllSheets() {
        return this.sheets.values();
    }

    protected boolean sheetInitialized(int index) {
        return this.sheets.containsKey(index);
    }

    @Override
    public void setRowHeight(int row, int height) {
        this.getOrCreateRow(row).setHeight((short)height);
    }

    @Override
    public void setColumnWidth(int column, int width) {
        this.getCurrentSheet().setColumnWidth(column, width);
    }

    @Override
    public void setColumnWidthAuto(int column) {
        this.getCurrentSheet().autoSizeColumn(column);
    }

    @Override
    public void setFreezePane(int colSplit, int rowSplit) {
        this.getCurrentSheet().createFreezePane(colSplit, rowSplit);
    }

    @Override
    public void setFreezePane(int colSplit, int rowSplit, int leftmostColumn, int topRow) {
        this.getCurrentSheet().createFreezePane(colSplit, rowSplit, leftmostColumn, topRow);
    }

    @Override
    public void setSplitPane(int xSplitPos, int ySplitPos, int leftmostColumn, int topRow, int activePane) {
        this.getCurrentSheet().createSplitPane(xSplitPos, ySplitPos, leftmostColumn, topRow, activePane);
    }

    @Override
    public void mergeRange(int firstRow, int firstColumn, int lastRow, int lastColumn) {
        this.getCurrentSheet().addMergedRegion((CellRangeAddress)new org.apache.poi.hssf.util.CellRangeAddress(firstRow, lastRow, firstColumn, lastColumn));
    }

    @Override
    public CellStyle newCellStyle() {
        return this.workbook.createCellStyle();
    }

    protected Cell getOrCreateCell(int i, int j) {
        Cell cell;
        Sheet sheet = this.getCurrentSheet();
        Row row = sheet.getRow(i);
        if (row == null) {
            row = sheet.createRow(i);
        }
        if ((cell = row.getCell(j)) == null) {
            cell = row.createCell(j);
        }
        return cell;
    }

    protected Row getOrCreateRow(int i) {
        Sheet sheet = this.getCurrentSheet();
        Row row = sheet.getRow(i);
        if (row == null) {
            row = sheet.createRow(i);
        }
        return row;
    }

    @Override
    public Comment addComment(Cell cell, String text, int row, int col, int colWidth, int rowHeight) {
        Comment comment = this.buildComment(text, row, col, colWidth, rowHeight);
        if (comment != null) {
            cell.setCellComment(comment);
        }
        return comment;
    }

    public Comment buildComment(String text, int row, int col, int colWidth, int rowHeight) {
        ClientAnchor anchor = this.create.createClientAnchor();
        anchor.setCol1(col);
        anchor.setCol2(col + colWidth);
        anchor.setRow1(row);
        anchor.setRow2(row + rowHeight);
        HSSFComment comment = null;
        if (this.drawing instanceof HSSFPatriarch) {
            HSSFPatriarch p = (HSSFPatriarch)this.drawing;
            comment = p.createComment((HSSFAnchor)anchor);
        } else if (this.drawing instanceof XSSFDrawing) {
            log.error((Object)"comments not supported on XSSFDrawing, i.e. XLSX files");
        }
        if (comment != null) {
            RichTextString str = this.create.createRichTextString(text);
            comment.setString(str);
            comment.setAuthor("");
            return comment;
        }
        return null;
    }

    @Override
    public CellStyle newColoredCellStyle(ByteColor color) {
        CellStyle style = this.newCellStyle();
        style.setFillForegroundColor(this.getColor(color).getIndex());
        style.setFillPattern((short)1);
        return style;
    }

    @Override
    public HSSFColor getColor(ByteColor color) {
        return this.getColor(color.r, color.g, color.b);
    }

    public HSSFColor getColor(byte r, byte g, byte b) {
        HSSFWorkbook hwb = this.getHSSFWorkbook();
        HSSFPalette palette = hwb.getCustomPalette();
        HSSFColor color = palette.findSimilarColor(r, g, b);
        return color;
    }

    @Override
    public int loadPicture(String image) throws IOException {
        FileInputStream is = new FileInputStream(image);
        byte[] bytes = IOUtils.toByteArray((InputStream)is);
        int pictureIdx = this.workbook.addPicture(bytes, 5);
        ((InputStream)is).close();
        return pictureIdx;
    }

    @Override
    public void setPicture(int pictureIdx, int col1, int row1, boolean resize) {
        ClientAnchor anchor = this.create.createClientAnchor();
        anchor.setCol1(col1);
        anchor.setRow1(row1);
        Picture pict = this.drawing.createPicture(anchor, pictureIdx);
        if (resize) {
            pict.resize();
        }
    }

    @Override
    public Font getBoldFont() {
        return this.boldFont;
    }

    @Override
    public Font newFont(int size) {
        Font newFont = this.workbook.createFont();
        newFont.setFontHeightInPoints((short)size);
        return newFont;
    }

    @Override
    public Font newFont() {
        return this.workbook.createFont();
    }

    @Override
    public void save(String file) throws IOException {
        this.save(new File(file));
    }

    @Override
    public void save(File file) throws IOException {
        FileOutputStream fileOut = new FileOutputStream(file);
        this.workbook.write((OutputStream)fileOut);
        fileOut.close();
    }

    @Override
    public Workbook load(String file) throws InvalidFormatException, IOException {
        return this.load(file);
    }

    @Override
    public Workbook load(File file) throws InvalidFormatException, IOException {
        FileInputStream inp = new FileInputStream(file);
        return WorkbookFactory.create((InputStream)inp);
    }

    public static enum Type {
        XLS,
        XLSX;

    }
}

