/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.groups.audit.service.acl.job.publish;

import java.io.File;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.platform.groups.audit.service.acl.job.publish.IResultPublisher;

public class PublishAsDocument
implements IResultPublisher {
    private static final Log log = LogFactory.getLog(PublishAsDocument.class);
    protected File fileToPublish;
    protected String documentName;
    protected String repository;
    protected DocumentModel parent;

    public PublishAsDocument(File fileToPublish, String documentName, String repository, DocumentModel parent) {
        this.fileToPublish = fileToPublish;
        this.documentName = documentName;
        this.repository = repository;
        this.parent = parent;
    }

    @Override
    public void publish() throws ClientException {
        log.debug((Object)"about to save audit");
        FileBlob b = new FileBlob(this.fileToPublish);
        b.setFilename(this.documentName);
        try {
            this.reconnectAndCreateDocument(this.repository, this.parent, this.documentName, (Blob)b);
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    protected void reconnectAndCreateDocument(String repository, final DocumentModel parent, final String name, final Blob doc) throws ClientException {
        new UnrestrictedSessionRunner(repository){

            public void run() throws ClientException {
                PublishAsDocument.this.createOrUpdateDocument(this.session, parent, name, doc);
                log.debug((Object)"audit saved");
            }
        }.runUnrestricted();
    }

    protected DocumentModel createOrUpdateDocument(CoreSession session, DocumentModel parent, String name, Blob doc) throws ClientException {
        PathRef dr = new PathRef(parent.getPath().append(name).toString());
        String filenamePlusExt = doc.getFilename();
        if (session.exists((DocumentRef)dr)) {
            DocumentModel document = session.getDocument((DocumentRef)dr);
            document.setPropertyValue("file:content", (Serializable)doc);
            document.setPropertyValue("file:filename", (Serializable)((Object)filenamePlusExt));
            document.setPropertyValue("dublincore:title", (Serializable)((Object)name));
            return session.saveDocument(document);
        }
        DocumentModel document = session.createDocumentModel(parent.getPathAsString(), IdUtils.generatePathSegment((String)name), "File");
        document.setPropertyValue("file:content", (Serializable)doc);
        document.setPropertyValue("file:filename", (Serializable)((Object)filenamePlusExt));
        document.setPropertyValue("dublincore:title", (Serializable)((Object)name));
        DocumentModel d = session.createDocument(document);
        return session.saveDocument(d);
    }
}

