/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.groups.audit.service.acl.job;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.groups.audit.service.acl.AclExcelLayoutBuilder;
import org.nuxeo.ecm.platform.groups.audit.service.acl.ReportLayoutSettings;
import org.nuxeo.ecm.platform.groups.audit.service.acl.filter.IContentFilter;
import org.nuxeo.ecm.platform.groups.audit.service.acl.job.Work;

public class RunnableAclAudit
implements Runnable {
    private static final Log log = LogFactory.getLog(RunnableAclAudit.class);
    protected transient CoreSession session;
    protected transient Work work;
    protected File out;
    protected DocumentModel root;

    public RunnableAclAudit(CoreSession session, DocumentModel root, Work work, File out) {
        this.session = session;
        this.root = root;
        this.work = work;
        this.out = out;
        if (this.work != null) {
            this.work.setRunnable(this);
        }
    }

    public RunnableAclAudit(CoreSession session, DocumentModel root, File out) {
        this(session, root, null, out);
    }

    @Override
    public void run() {
        this.doAudit();
        this.onAuditDone();
    }

    public void doAudit() {
        ReportLayoutSettings s = AclExcelLayoutBuilder.defaultLayout();
        s.setPageSize(1000);
        IContentFilter filter = null;
        log.debug((Object)"Start audit");
        AclExcelLayoutBuilder v = new AclExcelLayoutBuilder(s, filter);
        try {
            v.renderAudit(this.session, this.root, true, this.work);
            log.debug((Object)"End audit");
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
        try {
            v.getExcel().save(this.out);
            log.debug((Object)"End save");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void onAuditDone() {
    }

    public File getOutputFile() {
        return this.out;
    }
}

