/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.groups.audit.service;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.groups.audit.service.ExcelExportFactory;

@XObject(value="ExcelExport")
public class ExcelExportServiceDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XNode(value="@name")
    protected String name;
    @XNode(value="@factoryClass")
    private Class<? extends ExcelExportFactory> factoryClass;
    private File template;

    public String getName() {
        return this.name;
    }

    public File getTemplate() {
        return this.template;
    }

    @XNode(value="@template")
    public void setTemplate(String templatePath) {
        URL templateUrl = ExcelExportServiceDescriptor.class.getResource("/" + templatePath);
        try {
            this.template = File.createTempFile("ExcelTemplate", ".xls");
            this.template.createNewFile();
            FileUtils.copyURLToFile((URL)templateUrl, (File)this.template);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ExcelExportFactory getFactory() throws InstantiationException, IllegalAccessException {
        if (this.factoryClass != null) {
            return this.factoryClass.newInstance();
        }
        return null;
    }
}

