/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.groups.audit.service.acl.data;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.TransactionalCoreSessionWrapper;
import org.nuxeo.ecm.core.api.local.LocalSession;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class TransactionResetHelper {
    protected static Field handlerField = TransactionResetHelper.getHandlerField();

    public static void resetTransaction(CoreSession session) {
        try {
            TransactionHelper.commitOrRollbackTransaction();
            TransactionResetHelper.unwrapSession(session).dispose();
            TransactionHelper.startTransaction();
            session.getRootDocument();
        }
        catch (ClientException e) {
            throw new ClientRuntimeException("Cannot reset transaction context", (Throwable)e);
        }
    }

    public static Session unwrapSession(CoreSession session) throws ClientException {
        InvocationHandler handler;
        if (Proxy.isProxyClass(session.getClass()) && (handler = Proxy.getInvocationHandler(session)) instanceof TransactionalCoreSessionWrapper && handlerField != null) {
            try {
                session = (CoreSession)handlerField.get(handler);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (!(session instanceof LocalSession)) {
            throw new ClientException("Not a local session " + session.getClass());
        }
        return ((LocalSession)session).getSession();
    }

    public static Field getHandlerField() {
        Field field;
        try {
            field = TransactionalCoreSessionWrapper.class.getDeclaredField("session");
        }
        catch (Exception e) {
            return null;
        }
        field.setAccessible(true);
        return field;
    }
}

