/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.groups.audit.service.acl.job;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.platform.groups.audit.service.acl.AclExcelLayoutBuilder;
import org.nuxeo.ecm.platform.groups.audit.service.acl.ReportLayoutSettings;
import org.nuxeo.ecm.platform.groups.audit.service.acl.filter.IContentFilter;
import org.nuxeo.ecm.platform.groups.audit.service.acl.job.publish.IResultPublisher;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class AclAuditWork
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AclAuditWork.class);
    public static final String PROPERTY_ACL_AUDIT_TIMEOUT = "nuxeo.audit.acl.timeout";
    public static final int DEFAULT_TIMEOUT = 1200;
    public static final int UNDEFINED_TIMEOUT = -1;
    protected String name;
    protected int timeout;
    protected IResultPublisher publisher;
    protected File out;

    public AclAuditWork(String name, String repositoryName, String rootId, File out, IResultPublisher publisher) {
        this(name, repositoryName, rootId, out, publisher, AclAuditWork.getAclAuditTimeoutFromProperties());
    }

    public static int getAclAuditTimeoutFromProperties() {
        String v = Framework.getProperty((String)PROPERTY_ACL_AUDIT_TIMEOUT, (String)"-1");
        try {
            return Integer.parseInt(v);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public AclAuditWork(String name, String repositoryName, String rootId, File out, IResultPublisher publisher, int timeout) {
        super(repositoryName + ':' + rootId + ":aclAudit");
        this.setDocument(repositoryName, rootId, true);
        this.name = name;
        this.out = out;
        this.publisher = publisher;
        if (timeout == -1) {
            timeout = 1200;
        }
        this.timeout = timeout;
    }

    public String getTitle() {
        return this.name;
    }

    public void work() throws Exception {
        if (TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction((int)this.timeout);
        }
        this.setProgress(Work.Progress.PROGRESS_0_PC);
        this.initSession();
        this.doAudit();
        this.onAuditDone();
        this.setProgress(Work.Progress.PROGRESS_100_PC);
    }

    public void doAudit() {
        ReportLayoutSettings s = AclExcelLayoutBuilder.defaultLayout();
        s.setPageSize(1000);
        IContentFilter filter = null;
        log.debug((Object)"Start audit");
        AclExcelLayoutBuilder v = new AclExcelLayoutBuilder(s, filter);
        try {
            DocumentModel root = this.session.getDocument((DocumentRef)new IdRef(this.docId));
            v.renderAudit(this.session, root, true, this.timeout);
            log.debug((Object)"End audit");
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
        try {
            v.getExcel().save(this.out);
            log.debug((Object)"End save");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void onAuditDone() {
        FileBlob fb = new FileBlob(this.getOutputFile(), "application/xls");
        try {
            this.publisher.publish(fb);
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public File getOutputFile() {
        return this.out;
    }
}

