/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.groups.audit.seam;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.groups.audit.service.acl.excel.AclNameShortner;
import org.nuxeo.ecm.platform.groups.audit.service.acl.job.AclAuditWork;
import org.nuxeo.ecm.platform.groups.audit.service.acl.job.publish.PublishByMail;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.runtime.api.Framework;

@Name(value="excelExportRightsAction")
@Scope(value=ScopeType.EVENT)
public class ExcelExportRightsActionBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ExcelExportRightsActionBean.class);
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected NavigationContext navigationContext;
    @In(create=true)
    protected DocumentsListsManager documentsListsManager;
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    protected Map<String, String> messages;
    @In(create=true, required=false)
    protected NuxeoPrincipal currentNuxeoPrincipal;
    private static final String WORK_NAME = "Permission Audit for ";
    protected Set<String> existingPermissions = new HashSet<String>();

    public ExcelExportRightsActionBean() {
        AclNameShortner names = new AclNameShortner();
        this.existingPermissions.addAll(names.getFullNames());
    }

    public String doGet() {
        try {
            this.buildAndSendByMail();
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
            this.facesMessages.add(StatusMessage.Severity.ERROR, "doGet error: " + e.getMessage(), new Object[0]);
        }
        return null;
    }

    public boolean accept() {
        return true;
    }

    protected List<DocumentModel> getCurrentlySelectedDocuments() {
        if (this.navigationContext.getCurrentDocument().isFolder()) {
            return this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        }
        return null;
    }

    public void buildAndSendByMail() throws IOException {
        File tmpFile = Framework.createTempFile((String)"rights", (String)".xls");
        Framework.trackFile((File)tmpFile, (Object)tmpFile);
        this.buildAndSendByMail(tmpFile);
    }

    protected void buildAndSendByMail(File tmpFile) {
        DocumentModel auditRoot = this.navigationContext.getCurrentDocument();
        String repositoryName = this.documentManager.getRepositoryName();
        String to = this.currentNuxeoPrincipal.getEmail();
        String defaultFrom = "noreply@nuxeo.com";
        String workName = WORK_NAME + auditRoot.getPathAsString();
        WorkManager wm = (WorkManager)Framework.getLocalService(WorkManager.class);
        if (StringUtils.isBlank((String)to)) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, "Your email is missing from your profile.", new Object[0]);
            return;
        }
        PublishByMail publisher = new PublishByMail(to, "noreply@nuxeo.com", repositoryName);
        AclAuditWork work = new AclAuditWork(workName, repositoryName, auditRoot.getId(), tmpFile, publisher);
        wm.schedule((Work)work, true);
        String message = this.messages.get("message.acl.audit.started");
        this.facesMessages.add(StatusMessage.Severity.INFO, message, new Object[0]);
    }

    public Set<String> getExistingPermissions() {
        return this.existingPermissions;
    }
}

