/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.groups.audit.service.acl;

import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.nuxeo.ecm.platform.groups.audit.service.acl.AclExcelLayoutBuilder;
import org.nuxeo.ecm.platform.groups.audit.service.acl.Pair;
import org.nuxeo.ecm.platform.groups.audit.service.acl.ReportLayoutSettings;
import org.nuxeo.ecm.platform.groups.audit.service.acl.excel.ByteColor;
import org.nuxeo.ecm.platform.groups.audit.service.acl.excel.ExcelBuilder;
import org.nuxeo.ecm.platform.groups.audit.service.acl.filter.IContentFilter;

public class AclExcelLayoutBuilderMultiColumn
extends AclExcelLayoutBuilder {
    protected static int USERS_ROW = 0;
    protected static int PERMISSIONS_ROW = 1;
    protected CellStyle acceptStyle;
    protected CellStyle acceptStyleLeft;
    protected CellStyle acceptStyleRight;
    protected CellStyle denyStyle;
    protected CellStyle denyStyleLeft;
    protected CellStyle denyStyleRight;
    protected CellStyle emptyStyle;
    protected CellStyle emptyStyleLeft;
    protected CellStyle emptyStyleRight;
    protected int logoPictureId = -1;

    public static ReportLayoutSettings defaultLayout() {
        ReportLayoutSettings layout = new ReportLayoutSettings();
        layout.userHeaderHeight = -1;
        layout.userHeaderRotation = 0;
        layout.aclHeaderHeight = -1;
        layout.aclHeaderRotation = 0;
        layout.fileTreeColumnWidth = 2.5;
        layout.aclColumnWidth = 2.5;
        layout.defaultRowHeight = 100;
        layout.splitPaneX = 500;
        layout.splitPaneY = 1500;
        layout.freezePaneRowSplit = 2;
        layout.treeLineCursorRowStart = 2;
        layout.aclHeaderCommentColSpan = 10;
        layout.aclHeaderCommentRowSpan = 2;
        layout.aclHeaderFontSize = 6;
        layout.spanMode = ReportLayoutSettings.SpanMode.COLUMN_OVERFLOW_ON_NEXT_SHEETS;
        layout.zoomRatioDenominator = 2;
        layout.zoomRatioNumerator = 1;
        layout.logoImageFile = "src/main/resources/file-delete.png";
        return layout;
    }

    public AclExcelLayoutBuilderMultiColumn() {
        super(AclExcelLayoutBuilderMultiColumn.defaultLayout());
    }

    public AclExcelLayoutBuilderMultiColumn(IContentFilter filter) {
        this(AclExcelLayoutBuilderMultiColumn.defaultLayout(), filter);
    }

    public AclExcelLayoutBuilderMultiColumn(ReportLayoutSettings layout, IContentFilter filter) {
        super(layout, filter);
    }

    @Override
    protected void renderInit() {
        super.renderInit();
        this.acceptStyle = this.excel.newColoredCellStyle(ByteColor.GREEN);
        this.acceptStyleLeft = this.excel.newColoredCellStyle(ByteColor.GREEN);
        this.acceptStyleLeft.setBorderLeft((short)1);
        this.acceptStyleLeft.setLeftBorderColor(this.excel.getColor(ByteColor.BLACK).getIndex());
        this.acceptStyleRight = this.excel.newColoredCellStyle(ByteColor.GREEN);
        this.acceptStyleRight.setBorderRight((short)1);
        this.acceptStyleRight.setRightBorderColor(this.excel.getColor(ByteColor.BLACK).getIndex());
        this.denyStyle = this.excel.newColoredCellStyle(ByteColor.RED);
        this.denyStyle.setFillPattern((short)14);
        this.denyStyle.setFillBackgroundColor(this.excel.getColor(ByteColor.WHITE).getIndex());
        this.denyStyleLeft = this.excel.newColoredCellStyle(ByteColor.RED);
        this.denyStyleLeft.setBorderLeft((short)1);
        this.denyStyleLeft.setLeftBorderColor(this.excel.getColor(ByteColor.BLACK).getIndex());
        this.denyStyleRight = this.excel.newColoredCellStyle(ByteColor.RED);
        this.denyStyleRight.setBorderRight((short)1);
        this.denyStyleRight.setRightBorderColor(this.excel.getColor(ByteColor.BLACK).getIndex());
        this.emptyStyle = this.excel.newColoredCellStyle(ByteColor.WHITE);
        this.emptyStyleLeft = this.excel.newColoredCellStyle(ByteColor.WHITE);
        this.emptyStyleLeft.setBorderLeft((short)1);
        this.emptyStyleLeft.setLeftBorderColor(this.excel.getColor(ByteColor.BLACK).getIndex());
        this.emptyStyleRight = this.excel.newColoredCellStyle(ByteColor.WHITE);
        this.emptyStyleRight.setBorderRight((short)1);
        this.emptyStyleRight.setRightBorderColor(this.excel.getColor(ByteColor.BLACK).getIndex());
        if (this.layoutSettings.logoImageFile != null) {
            try {
                this.logoPictureId = this.excel.loadPicture(this.layoutSettings.logoImageFile);
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    @Override
    protected void renderHeader(int tableStartColumn, Set<String> userOrGroups, Set<String> permissions) {
        this.renderHeaderPicture();
        this.renderHeaderUsers(tableStartColumn, userOrGroups, permissions);
        this.renderHeaderAcl(userOrGroups, permissions);
        this.formatHeaderRowHeight();
    }

    protected void renderHeaderPicture() {
        this.excel.setPicture(this.logoPictureId, 0, 0, false);
    }

    protected void renderHeaderUsers(int tableStartColumn, Set<String> userOrGroups, Set<String> permissions) {
        int userColumn = tableStartColumn;
        for (String user : userOrGroups) {
            this.excel.setCell(USERS_ROW, userColumn, user, this.userHeaderStyle);
            this.layout.setUserColumn(userColumn, user);
            int from = userColumn;
            int to = userColumn + permissions.size() - 1;
            if (from < ExcelBuilder.LAST_COLUMN && to < ExcelBuilder.LAST_COLUMN) {
                this.excel.mergeRange(USERS_ROW, from, USERS_ROW, to);
            }
            log.debug((Object)("user header: " + USERS_ROW + "," + (userColumn += permissions.size()) + " > " + user));
        }
    }

    protected void renderHeaderAcl(Set<String> userOrGroups, Set<String> permissions) {
        for (String user : userOrGroups) {
            int aclColumn = 0;
            int aclHeaderColumn = 0;
            for (String permission : permissions) {
                int userColumn = this.layout.getUserColumn(user);
                aclHeaderColumn = userColumn + aclColumn;
                String aclHeaderText = permission;
                String aclHeaderShort = this.formatPermission(permission);
                Cell cell = this.excel.setCell(PERMISSIONS_ROW, aclHeaderColumn, aclHeaderShort, this.aclHeaderStyle);
                this.excel.setColumnWidth(aclHeaderColumn, (int)(this.layoutSettings.aclColumnWidth * (double)CELL_WIDTH_UNIT));
                if (aclHeaderColumn + this.layoutSettings.aclHeaderCommentColSpan < ExcelBuilder.LAST_COLUMN) {
                    this.excel.addComment(cell, aclHeaderText, PERMISSIONS_ROW, aclHeaderColumn, this.layoutSettings.aclHeaderCommentColSpan, this.layoutSettings.aclHeaderCommentRowSpan);
                }
                this.layout.setUserAclColumn(aclHeaderColumn, Pair.of(user, permission));
                ++aclColumn;
                log.debug((Object)("permission header: " + PERMISSIONS_ROW + "," + aclHeaderColumn + " > " + this.formatPermission(permission)));
            }
        }
    }

    protected void formatHeaderRowHeight() {
        if (this.layoutSettings.aclHeaderHeight != -1) {
            this.excel.setRowHeight(PERMISSIONS_ROW, this.layoutSettings.aclHeaderHeight);
        }
        if (this.layoutSettings.userHeaderHeight != -1) {
            this.excel.setRowHeight(USERS_ROW, this.layoutSettings.userHeaderHeight);
        }
    }

    @Override
    protected void renderAcl(Multimap<String, Pair<String, Boolean>> userAcls) {
        for (String user : userAcls.keySet()) {
            ArrayList acls = new ArrayList(userAcls.get((Object)user));
            int last = acls.size() - 1;
            for (int i = 0; i < acls.size(); ++i) {
                boolean isFirst = false;
                boolean isLast = false;
                Pair ace = (Pair)acls.get(i);
                String permission = (String)ace.a;
                boolean accept = (Boolean)ace.b;
                int aclColumn = this.layout.getUserAclColumn(Pair.of(user, permission));
                String aceText = "";
                if (accept) {
                    this.renderAcceptCell(isFirst, isLast, aclColumn, aceText);
                    continue;
                }
                this.renderDenyCell(isFirst, isLast, aclColumn, aceText);
            }
        }
    }

    protected void renderDenyCell(boolean isFirst, boolean isLast, int aclColumn, String aceText) {
        if (isFirst) {
            this.excel.setCell(this.treeLineCursor, aclColumn, aceText, this.denyStyleLeft);
        } else if (isLast) {
            this.excel.setCell(this.treeLineCursor, aclColumn, aceText, this.denyStyleRight);
        } else {
            this.excel.setCell(this.treeLineCursor, aclColumn, aceText, this.denyStyle);
        }
    }

    protected void renderAcceptCell(boolean isFirst, boolean isLast, int aclColumn, String aceText) {
        if (isFirst) {
            this.excel.setCell(this.treeLineCursor, aclColumn, aceText, this.acceptStyleLeft);
        } else if (isLast) {
            this.excel.setCell(this.treeLineCursor, aclColumn, aceText, this.acceptStyleRight);
        } else {
            this.excel.setCell(this.treeLineCursor, aclColumn, aceText, this.acceptStyle);
        }
    }
}

