/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.groups.audit.service.acl.data;

import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.groups.audit.service.acl.data.DataFetch;
import org.nuxeo.ecm.platform.groups.audit.service.acl.data.DataProcessor;
import org.nuxeo.ecm.platform.groups.audit.service.acl.data.DocumentSummary;
import org.nuxeo.ecm.platform.groups.audit.service.acl.excel.ExcelBuilder;
import org.nuxeo.ecm.platform.groups.audit.service.acl.filter.IContentFilter;
import org.nuxeo.ecm.platform.query.nxql.CoreQueryDocumentPageProvider;

public class DataProcessorPaginated
extends DataProcessor {
    public static int MAX_DOCUMENTS = ExcelBuilder.MAX_ROW - 2;
    public static int DEFAULT_PAGE_SIZE = 1000;
    public static int EXCEL_RENDERING_RESERVED_TIME = 90;
    protected static int UNBOUNDED_PROCESS_TIME = -1;
    protected int pageSize = DEFAULT_PAGE_SIZE;
    protected int p = 0;

    public DataProcessorPaginated(IContentFilter filter) {
        this(filter, DEFAULT_PAGE_SIZE);
    }

    public DataProcessorPaginated(IContentFilter filter, int pageSize) {
        super(filter);
        this.pageSize = pageSize;
    }

    @Override
    protected void doAnalyze(CoreSession session, DocumentModel root, int timeout) {
        DataFetch fetch = new DataFetch();
        CoreQueryDocumentPageProvider pages = fetch.getAllChildrenPaginated(session, root, this.pageSize, false);
        this.initSummarySet();
        this.processDocument(root);
        this.t.tic();
        int maxProcessTime = UNBOUNDED_PROCESS_TIME;
        if (timeout > 0 && (maxProcessTime = timeout - EXCEL_RENDERING_RESERVED_TIME) <= 0) {
            throw new IllegalArgumentException("can't start a time bounded process with a timeout < " + EXCEL_RENDERING_RESERVED_TIME + "(time period reserved for excel rendering)");
        }
        this.status = DataProcessor.ProcessorStatus.SUCCESS;
        block0: do {
            log.debug((Object)("will get page " + this.p));
            List page = pages.getCurrentPage();
            log.debug((Object)("page retrieved with query: " + pages.getCurrentQuery()));
            log.debug((Object)("page size: " + page.size()));
            for (DocumentModel m : page) {
                this.processDocument(m);
                this.t.toc();
                if (this.getNumberOfDocuments() == MAX_DOCUMENTS) {
                    this.status = DataProcessor.ProcessorStatus.ERROR_TOO_MANY_DOCUMENTS;
                    break block0;
                }
                if (maxProcessTime == UNBOUNDED_PROCESS_TIME || !(this.t.toc() >= (double)maxProcessTime)) continue;
                this.status = DataProcessor.ProcessorStatus.ERROR_TOO_LONG_PROCESS;
                break block0;
            }
            pages.nextPage();
            log.debug((Object)("done page " + this.p++));
        } while (pages.isNextPageAvailable());
    }

    @Override
    public void initSummarySet() {
        this.allDocuments = new TreeSet<DocumentSummary>(new Comparator<DocumentSummary>(){

            @Override
            public int compare(DocumentSummary arg0, DocumentSummary arg1) {
                String dp0 = arg0.getPath();
                String dp1 = arg1.getPath();
                return dp0.compareTo(dp1);
            }
        });
    }
}

