/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.notification.listener;

import java.util.HashMap;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.notification.NotificationService;
import org.nuxeo.runtime.api.Framework;

public class AutoSubscribeAtCreationListener
implements EventListener {
    public void handleEvent(Event event) {
        NuxeoPrincipal originatingUser = event.getContext().getPrincipal();
        if (originatingUser == null || "system".equals(originatingUser.getName()) || originatingUser.isAdministrator()) {
            return;
        }
        this.subscribeUserToSourceDocumentInEvent(event, originatingUser.getName(), "documentUpdated");
    }

    public void subscribeUserToSourceDocumentInEvent(Event event, String user, String resolverName) {
        if (!(event.getContext() instanceof DocumentEventContext)) {
            throw new NuxeoException(String.format("The event %s is not a Document event.", event.getName()));
        }
        DocumentModel route = ((DocumentEventContext)event.getContext()).getSourceDocument();
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put("sourceId", route.getId());
        NotificationService ns = (NotificationService)Framework.getService(NotificationService.class);
        ns.subscribe(user, resolverName, ctx);
    }
}

