/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.notification.listener;

import java.util.Collections;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.notification.NotificationService;
import org.nuxeo.runtime.api.Framework;

public class AutoSubscribeWorkflowListener
implements EventListener {
    public void handleEvent(Event event) {
        String initiator = (String)((Object)event.getContext().getProperty("workflowInitiator"));
        if (initiator == null || initiator.equals("system")) {
            return;
        }
        this.subscribeUserToWorkflow(event, initiator, "workflow");
    }

    public void subscribeUserToWorkflow(Event event, String user, String resolverName) {
        if (!(event.getContext() instanceof DocumentEventContext)) {
            throw new NuxeoException(String.format("The event %s is not a Document event.", event.getName()));
        }
        DocumentModel route = ((DocumentEventContext)event.getContext()).getSourceDocument();
        NotificationService ns = (NotificationService)Framework.getService(NotificationService.class);
        ns.subscribe(user, resolverName, Collections.singletonMap("wfId", route.getId()));
    }
}

