/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.notification.resolver;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.nuxeo.ecm.collections.core.adapter.CollectionMember;
import org.nuxeo.ecm.notification.NotificationService;
import org.nuxeo.ecm.notification.message.EventRecord;
import org.nuxeo.ecm.notification.resolver.AbstractCollectionResolver;
import org.nuxeo.runtime.api.Framework;

public class CollectionResolver
extends AbstractCollectionResolver {
    public boolean accept(EventRecord eventRecord) {
        return eventRecord.getEventName().equals("documentModified") && (Boolean)CollectionResolver.withDocument((EventRecord)eventRecord, doc -> doc.hasSchema("collectionMember")) != false;
    }

    public Map<String, String> buildNotifierContext(String targetUsername, EventRecord eventRecord) {
        List collectionsId = (List)CollectionResolver.withDocument((EventRecord)eventRecord, doc -> ((CollectionMember)doc.getAdapter(CollectionMember.class)).getCollectionIds());
        NotificationService ns = (NotificationService)Framework.getService(NotificationService.class);
        String collectionId = collectionsId.stream().filter(id -> ns.hasSubscribe(targetUsername, this.getId(), Collections.singletonMap("collectionDocId", id))).findFirst().orElse(null);
        if (collectionId != null) {
            return Collections.singletonMap("collectionDocId", collectionId);
        }
        return Collections.emptyMap();
    }

    public Stream<String> resolveTargetUsers(EventRecord eventRecord) {
        HashSet targetUsers = new HashSet();
        ((List)CollectionResolver.withDocument((EventRecord)eventRecord, doc -> ((CollectionMember)doc.getAdapter(CollectionMember.class)).getCollectionIds())).forEach(collectionId -> {
            HashMap<String, String> ctx = new HashMap<String, String>();
            ctx.put("collectionDocId", (String)collectionId);
            this.getSubscriptions(ctx).getUsernames().forEach(targetUsers::add);
        });
        return targetUsers.stream();
    }
}

