/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.notification.resolver;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Stream;
import org.nuxeo.ecm.notification.message.EventRecord;
import org.nuxeo.ecm.notification.resolver.AbstractCollectionResolver;

public class CollectionUpdatesResolver
extends AbstractCollectionResolver {
    public static final String CTX_ACTION = "action";
    public static final String CTX_ACTION_SUFFIX = "actionSuffix";

    public boolean accept(EventRecord eventRecord) {
        return eventRecord.getEventName().equals("addedToCollection") || eventRecord.getEventName().equals("removedFromCollection");
    }

    public Map<String, String> buildNotifierContext(String targetUsername, EventRecord eventRecord) {
        HashMap<String, String> ctx = new HashMap<String, String>();
        if (eventRecord.getEventName().equals("addedToCollection")) {
            ctx.put(CTX_ACTION, "added");
            ctx.put(CTX_ACTION_SUFFIX, "to");
        } else {
            ctx.put(CTX_ACTION, "removed");
            ctx.put(CTX_ACTION_SUFFIX, "from");
        }
        return ctx;
    }

    public Stream<String> resolveTargetUsers(EventRecord eventRecord) {
        HashSet targetUsers = new HashSet();
        this.getSubscriptions(eventRecord.getContext()).getUsernames().forEach(targetUsers::add);
        return targetUsers.stream();
    }
}

