/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.notification.resolver;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.notification.NotificationService;
import org.nuxeo.ecm.notification.message.EventRecord;
import org.nuxeo.ecm.notification.resolver.SubscribableResolver;
import org.nuxeo.runtime.api.Framework;

public class DescendantChangesResolver
extends SubscribableResolver {
    public static final String ANCESTOR_ID = "ancestorId";

    public List<String> getRequiredContextFields() {
        return Arrays.asList("sourceId");
    }

    public boolean accept(EventRecord eventRecord) {
        return eventRecord.getEventName().equals("documentModified") || eventRecord.getEventName().equals("documentCreated");
    }

    public Stream<String> resolveTargetUsers(EventRecord eventRecord) {
        HashSet sb = new HashSet();
        DocumentRef[] parent = (DocumentRef[])DescendantChangesResolver.withSession((EventRecord)eventRecord, session -> session.getParentDocumentRefs(eventRecord.getDocumentSourceRef()));
        Arrays.stream(parent).map(Object::toString).forEach(s -> {
            EventRecord parentRecord = EventRecord.builder().fromEvent(eventRecord).withDocumentId(s).build();
            super.resolveTargetUsers(parentRecord).forEach(sb::add);
        });
        return sb.stream();
    }

    public Map<String, String> buildNotifierContext(String targetUsername, EventRecord eventRecord) {
        DocumentRef[] parent = (DocumentRef[])DescendantChangesResolver.withSession((EventRecord)eventRecord, session -> session.getParentDocumentRefs(eventRecord.getDocumentSourceRef()));
        String ancestorId = Arrays.stream(parent).map(Object::toString).filter(s -> ((NotificationService)Framework.getService(NotificationService.class)).hasSubscribe(targetUsername, this.getId(), Collections.singletonMap("sourceId", s))).findFirst().orElse(null);
        if (ancestorId != null) {
            return Collections.singletonMap(ANCESTOR_ID, ancestorId);
        }
        return Collections.emptyMap();
    }

    public void subscribe(String username, Map<String, String> ctx) {
        EventRecord tmpRecord = EventRecord.builder().withUsername(username).withDocumentId(ctx.get("sourceId")).build();
        boolean isFolder = (Boolean)DescendantChangesResolver.withDocument((EventRecord)tmpRecord, DocumentModel::isFolder);
        if (!isFolder) {
            throw new NuxeoException("Unable to subscribe to this resolver with a non-folderish document: " + tmpRecord.getDocumentSourceId());
        }
        super.subscribe(username, ctx);
    }
}

