/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.notification.resolver;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.notification.message.EventRecord;
import org.nuxeo.ecm.notification.resolver.SubscribableResolver;

public class DocumentUpdateResolver
extends SubscribableResolver {
    public static final String RESOLVER_NAME = "documentUpdated";
    public static final String COMMENT_ID_KEY = "commentIdKey";
    public static final String COMMENT_AUTHOR_KEY = "commentAuthorKey";

    public List<String> getRequiredContextFields() {
        return Arrays.asList("sourceId");
    }

    public boolean accept(EventRecord eventRecord) {
        return eventRecord.getEventName().equals("documentModified") || eventRecord.getEventName().equals("documentCreated") && "Comment".equals(eventRecord.getDocumentSourceType());
    }

    public Map<String, String> buildNotifierContext(String targetUsername, EventRecord eventRecord) {
        HashMap<String, String> ctx = new HashMap<String, String>();
        if ("Comment".equals(eventRecord.getDocumentSourceType())) {
            ctx.put("sourceId", this.getAncestorId(eventRecord));
            ctx.put(COMMENT_ID_KEY, eventRecord.getDocumentSourceId());
            ctx.put(COMMENT_AUTHOR_KEY, eventRecord.getUsername());
        }
        return ctx;
    }

    public Stream<String> resolveTargetUsers(EventRecord eventRecord) {
        if ("Comment".equals(eventRecord.getDocumentSourceType())) {
            HashMap<String, String> ctx = new HashMap<String, String>();
            ctx.put("sourceId", this.getAncestorId(eventRecord));
            HashSet targetUsers = new HashSet();
            this.getSubscriptions(ctx).getUsernames().forEach(targetUsers::add);
            return targetUsers.stream();
        }
        return super.resolveTargetUsers(eventRecord);
    }

    protected String getAncestorId(EventRecord eventRecord) {
        return (String)DocumentUpdateResolver.withDocument((EventRecord)eventRecord, d -> {
            List ancestors = ((List)((Object)d.getPropertyValue("comment:ancestorIds"))).stream().filter(id -> d.getCoreSession().getDocument((DocumentRef)new IdRef(id)).hasFacet("Commentable")).collect(Collectors.toList());
            if (ancestors.size() > 0) {
                return (String)ancestors.get(0);
            }
            return null;
        });
    }
}

