/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.notification.resolver;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.notification.message.EventRecord;
import org.nuxeo.ecm.notification.resolver.Resolver;

public class TaskAssignedResolver
extends Resolver {
    public static final List<String> ACCEPTED_EVENTS = Arrays.asList("workflowTaskAssigned", "workflowTaskReassigned", "workflowTaskDelegated");

    public boolean accept(EventRecord eventRecord) {
        return ACCEPTED_EVENTS.contains(eventRecord.getEventName());
    }

    public Stream<String> resolveTargetUsers(EventRecord eventRecord) {
        if (eventRecord.getContext().get("recipients") != null) {
            return Arrays.stream(((String)eventRecord.getContext().get("recipients")).split(":")).filter(k -> StringUtils.isNotBlank((CharSequence)k));
        }
        return null;
    }

    public Map<String, String> buildNotifierContext(String targetUsername, EventRecord eventRecord) {
        return Collections.emptyMap();
    }
}

