/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.notification.resolver;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.notification.message.EventRecord;
import org.nuxeo.ecm.notification.resolver.SubscribableResolver;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingConstants;

public class WorkflowUpdatesResolver
extends SubscribableResolver {
    public static final String RESOLVER_NAME = "workflow";
    public static final List<String> ACCEPTED_EVENTS = Arrays.asList(DocumentRoutingConstants.Events.workflowCanceled.name(), DocumentRoutingConstants.Events.afterWorkflowFinish.name(), DocumentRoutingConstants.Events.afterWorkflowTaskEnded.name());
    public static final String WORKFLOW_ID_KEY = "wfId";
    public static final String CTX_ACTION = "action";
    public static final String CTX_TARGET = "target";
    public static final String CTX_TARGET_ID = "targetId";

    public List<String> getRequiredContextFields() {
        return Collections.singletonList(WORKFLOW_ID_KEY);
    }

    public boolean accept(EventRecord eventRecord) {
        return ACCEPTED_EVENTS.contains(eventRecord.getEventName());
    }

    public Map<String, String> buildNotifierContext(String targetUsername, EventRecord eventRecord) {
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put(WORKFLOW_ID_KEY, (String)eventRecord.getContext().get(WORKFLOW_ID_KEY));
        if (eventRecord.getEventName().equals(DocumentRoutingConstants.Events.afterWorkflowTaskEnded.name())) {
            ctx.put(CTX_TARGET, "task");
            ctx.put(CTX_ACTION, "completed");
            ctx.put(CTX_TARGET_ID, eventRecord.getDocumentSourceId());
        } else {
            ctx.put(CTX_TARGET, RESOLVER_NAME);
            ctx.put(CTX_TARGET_ID, (String)eventRecord.getContext().get(WORKFLOW_ID_KEY));
            ctx.put(CTX_ACTION, eventRecord.getEventName().equals(DocumentRoutingConstants.Events.workflowCanceled.name()) ? "canceled" : "completed");
        }
        return ctx;
    }
}

