/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.notification.transformer;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.InstanceRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.notification.transformer.EventTransformer;

public class CollectionEventTransformer
extends EventTransformer {
    public boolean accept(Event event) {
        return event.getName().equals("addedToCollection") || event.getName().equals("removedFromCollection");
    }

    public Map<String, String> buildEventRecordContext(Event event) {
        HashMap<String, String> ctx = new HashMap<String, String>();
        DocumentRef collectionRef = (DocumentRef)event.getContext().getProperty("collectionRef");
        if (collectionRef instanceof InstanceRef) {
            ctx.put("collectionDocId", ((DocumentModel)collectionRef.reference()).getId());
        } else if (collectionRef instanceof PathRef) {
            DocumentModel collection = event.getContext().getCoreSession().getDocument(collectionRef);
            ctx.put("collectionDocId", collection.getId());
        } else {
            ctx.put("collectionDocId", collectionRef.toString());
        }
        return ctx;
    }
}

