/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.notification.transformer;

import java.util.Collections;
import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.notification.resolver.WorkflowUpdatesResolver;
import org.nuxeo.ecm.notification.transformer.EventTransformer;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingConstants;
import org.nuxeo.ecm.platform.task.Task;

public class WorkflowEventTransformer
extends EventTransformer {
    public boolean accept(Event event) {
        return WorkflowUpdatesResolver.ACCEPTED_EVENTS.contains(event.getName());
    }

    public Map<String, String> buildEventRecordContext(Event event) {
        String wfId;
        if (event.getName().equals(DocumentRoutingConstants.Events.workflowCanceled.name())) {
            wfId = (String)event.getContext().getProperties().get("wfId");
        } else if (event.getName().equals(DocumentRoutingConstants.Events.afterWorkflowTaskEnded.name())) {
            DocumentModel taskDoc = ((DocumentEventContext)event.getContext()).getSourceDocument();
            Task task = (Task)taskDoc.getAdapter(Task.class);
            wfId = task.getProcessId();
        } else {
            wfId = ((DocumentEventContext)event.getContext()).getSourceDocument().getId();
        }
        return Collections.singletonMap("wfId", wfId);
    }
}

