/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.permissions;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitFilteringEventListener;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.permissions.PermissionHelper;
import org.nuxeo.ecm.permissions.TransientUserPermissionHelper;
import org.nuxeo.runtime.api.Framework;

public class ACEStatusUpdatedListener
implements PostCommitFilteringEventListener {
    public void handleEvent(EventBundle events) {
        for (Event event : events) {
            this.handleEvent(event);
        }
    }

    protected void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        String repositoryName = (String)((Object)ctx.getProperty("repositoryName"));
        Map refsToACEs = (Map)((Object)ctx.getProperty("documentRefs"));
        if (repositoryName == null || refsToACEs == null) {
            return;
        }
        try (CoreSession session = CoreInstance.openCoreSessionSystem((String)repositoryName);){
            refsToACEs.keySet().stream().filter(arg_0 -> ((CoreSession)session).exists(arg_0)).forEach(ref -> {
                DocumentModel doc = session.getDocument(ref);
                this.checkForEffectiveACE(session, doc, (List)refsToACEs.get(ref));
            });
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void checkForEffectiveACE(CoreSession session, DocumentModel doc, List<ACE> aces) {
        directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
        for (ACE ace : aces) {
            if (!ace.isGranted()) continue;
            switch (1.$SwitchMap$org$nuxeo$ecm$core$api$security$ACE$Status[ace.getStatus().ordinal()]) {
                case 1: {
                    aclName = (String)ace.getContextData("changedACLName");
                    if (aclName == null) break;
                    dirSession = directoryService.open("aceinfo");
                    var9_9 = null;
                    id = PermissionHelper.computeDirectoryId(doc, aclName, ace.getId());
                    entry = dirSession.getEntry(id);
                    if (entry != null) {
                        notify = (Boolean)entry.getPropertyValue("aceinfo:notify");
                        comment = (String)entry.getPropertyValue("aceinfo:comment");
                        if (notify) {
                            ace.putContextData("comment", (Serializable)comment);
                            PermissionHelper.firePermissionNotificationEvent(session, doc, aclName, ace);
                        }
                    }
                    if (dirSession == null) break;
                    if (var9_9 == null) ** GOTO lbl27
                    try {
                        dirSession.close();
                    }
                    catch (Throwable var10_11) {
                        var9_9.addSuppressed(var10_11);
                    }
                    break;
lbl27:
                    // 1 sources

                    dirSession.close();
                    break;
                    catch (Throwable var10_12) {
                        try {
                            var9_9 = var10_12;
                            throw var10_12;
                        }
                        catch (Throwable var14_16) {
                            if (dirSession != null) {
                                if (var9_9 != null) {
                                    try {
                                        dirSession.close();
                                    }
                                    catch (Throwable var15_17) {
                                        var9_9.addSuppressed(var15_17);
                                    }
                                } else {
                                    dirSession.close();
                                }
                            }
                            throw var14_16;
                        }
                    }
                }
                case 2: {
                    TransientUserPermissionHelper.revokeToken(ace.getUsername(), doc);
                }
            }
        }
    }

    public boolean acceptEvent(Event event) {
        return "ACEStatusUpdated".equals(event.getName());
    }
}

