/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.poll;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.poll.Poll;
import org.nuxeo.ecm.poll.PollHelper;
import org.nuxeo.ecm.poll.PollResult;
import org.nuxeo.ecm.poll.PollService;
import org.nuxeo.ecm.webapp.contentbrowser.DocumentActions;

@Name(value="pollActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class PollActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SURVEYS_TAB = ":TAB_SURVEYS";
    protected static final Log log = LogFactory.getLog(PollActions.class);
    @In(create=true)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient DocumentActions documentActions;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected transient WebActions webActions;
    @In(create=true)
    protected transient PollService pollService;
    protected boolean showCreateForm = false;
    protected DocumentModel newPoll;

    public DocumentModel getPollsContainer() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return this.getPollsContainer(currentDocument);
    }

    public DocumentModel getPollsContainer(DocumentModel doc) throws ClientException {
        return this.pollService.getPollsContainer(doc);
    }

    public boolean isShowCreateForm() {
        return this.showCreateForm;
    }

    public void toggleCreateForm() {
        this.showCreateForm = !this.showCreateForm;
    }

    public void toggleAndReset() {
        this.toggleCreateForm();
        this.resetNewPoll();
    }

    protected void resetNewPoll() {
        this.newPoll = null;
    }

    public DocumentModel getNewPoll() throws ClientException {
        if (this.newPoll == null) {
            this.newPoll = this.documentManager.createDocumentModel("Poll");
        }
        return this.newPoll;
    }

    public void createPoll() throws ClientException {
        this.documentActions.saveDocument(this.newPoll);
        this.resetNewPoll();
        this.toggleCreateForm();
    }

    public Poll toPoll(DocumentModel poll) {
        return PollHelper.toPoll((DocumentModel)poll);
    }

    public void openPoll(DocumentModel poll) throws ClientException {
        this.pollService.openPoll(this.toPoll(poll));
    }

    public void closePoll(DocumentModel poll) throws ClientException {
        this.pollService.closePoll(this.toPoll(poll));
    }

    public String backToPollsListing(DocumentModel poll) throws ClientException {
        DocumentModel superSpace = this.documentManager.getSuperSpace(poll);
        String view = this.navigationContext.navigateToDocument(superSpace);
        this.webActions.setCurrentTabIds(SURVEYS_TAB);
        return view;
    }

    public boolean hasUnansweredOpenPolls() {
        return !this.pollService.getUnansweredOpenPolls(this.documentManager).isEmpty();
    }

    public boolean displayResults(DocumentModel pollDoc) {
        Poll poll = this.toPoll(pollDoc);
        if (poll.isInProject()) {
            return false;
        }
        if (poll.isOpen()) {
            PollResult pollResult = this.pollService.getResultFor(poll);
            return pollResult.getResultsCount() != 0L;
        }
        return true;
    }
}

