/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;

@WebObject(type="repo")
public class RepositoryObject
extends DefaultObject {
    @Path(value="path/@{adapterName}")
    public Object getRootPathAdapter(@PathParam(value="adapterName") String adapterName) throws ClientException {
        DocumentModel rootDocument = this.getContext().getCoreSession().getRootDocument();
        return this.ctx.newAdapter(this.newObject("Document", new Object[]{rootDocument}), adapterName, new Object[0]);
    }

    @Path(value="path{docPath:(/(?:(?!/@).)*)}")
    public Object getDocsByPath(@PathParam(value="docPath") String docPath) throws ClientException {
        CoreSession session = this.getContext().getCoreSession();
        DocumentModel doc = session.getDocument((DocumentRef)new PathRef(docPath));
        return this.newObject("Document", new Object[]{doc});
    }

    @Path(value="id/{id}")
    public Object getDocsById(@PathParam(value="id") String id) throws ClientException {
        CoreSession session = this.getContext().getCoreSession();
        DocumentModel doc = session.getDocument((DocumentRef)new IdRef(id));
        return this.newObject("Document", new Object[]{doc});
    }

    @Path(value="bulk")
    public Object getBulkDocuments(@MatrixParam(value="id") List<String> ids) throws ClientException {
        CoreSession session = this.getContext().getCoreSession();
        ArrayList<DocumentModel> docs = new ArrayList<DocumentModel>(ids.size());
        for (String loopid : ids) {
            docs.add(session.getDocument((DocumentRef)new IdRef(loopid)));
        }
        return this.newObject("bulk", new Object[]{new DocumentModelListImpl(docs)});
    }

    @Path(value="{otherPath}")
    public Object route(@PathParam(value="otherPath") String otherPath) {
        return this.newObject(otherPath, new Object[0]);
    }
}

