/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.adapters;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.exceptions.IllegalParameterException;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

@WebAdapter(name="convert", type="convertAdapter")
public class ConvertAdapter
extends DefaultAdapter {
    public static final String NAME = "convert";

    @GET
    public Blob convert(@QueryParam(value="converter") String converter, @QueryParam(value="type") String type, @QueryParam(value="format") String format, @Context UriInfo uriInfo) {
        BlobHolder bh;
        DocumentModel doc;
        Blob blob = (Blob)this.getTarget().getAdapter(Blob.class);
        if (blob == null && (doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class)) != null && (bh = (BlobHolder)doc.getAdapter(BlobHolder.class)) != null) {
            blob = bh.getBlob();
        }
        if (blob == null) {
            throw new IllegalParameterException("No Blob found");
        }
        boolean txWasActive = false;
        try {
            Blob blob2;
            if (TransactionHelper.isTransactionActive()) {
                txWasActive = true;
                TransactionHelper.commitOrRollbackTransaction();
            }
            if (StringUtils.isNotBlank((String)converter)) {
                blob2 = this.convertWithConverter(blob, converter, uriInfo);
                return blob2;
            }
            if (StringUtils.isNotBlank((String)type)) {
                blob2 = this.convertWithMimeType(blob, type, uriInfo);
                return blob2;
            }
            if (StringUtils.isNotBlank((String)format)) {
                blob2 = this.convertWithFormat(blob, format, uriInfo);
                return blob2;
            }
            throw new IllegalParameterException("No converter, type or format parameter specified");
        }
        finally {
            if (txWasActive && !TransactionHelper.isTransactionActiveOrMarkedRollback()) {
                TransactionHelper.startTransaction();
            }
        }
    }

    protected Blob convertWithConverter(Blob blob, String converter, UriInfo uriInfo) {
        ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
        if (!conversionService.isConverterAvailable(converter).isAvailable()) {
            throw new IllegalParameterException(String.format("The '%s' converter is not available", converter));
        }
        Map<String, Serializable> parameters = this.computeConversionParameters(uriInfo);
        BlobHolder blobHolder = conversionService.convert(converter, (BlobHolder)new SimpleBlobHolder(blob), parameters);
        Blob conversionBlob = blobHolder.getBlob();
        if (conversionBlob == null) {
            throw new WebResourceNotFoundException(String.format("No converted Blob using '%s' converter", converter));
        }
        return conversionBlob;
    }

    protected Map<String, Serializable> computeConversionParameters(UriInfo uriInfo) {
        MultivaluedMap queryParams = uriInfo.getQueryParameters();
        HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
        for (String parameterKey : queryParams.keySet()) {
            parameters.put(parameterKey, (Serializable)queryParams.getFirst((Object)parameterKey));
        }
        return parameters;
    }

    protected Blob convertWithMimeType(Blob blob, String mimeType, UriInfo uriInfo) {
        Map<String, Serializable> parameters = this.computeConversionParameters(uriInfo);
        ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
        BlobHolder blobHolder = conversionService.convertToMimeType(mimeType, (BlobHolder)new SimpleBlobHolder(blob), parameters);
        Blob conversionBlob = blobHolder.getBlob();
        if (conversionBlob == null) {
            throw new WebResourceNotFoundException(String.format("No converted Blob for '%s' mime type", mimeType));
        }
        return conversionBlob;
    }

    protected Blob convertWithFormat(Blob blob, String format, UriInfo uriInfo) {
        MimetypeRegistry mimetypeRegistry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        String mimeType = mimetypeRegistry.getMimetypeFromExtension(format);
        return this.convertWithMimeType(blob, mimeType, uriInfo);
    }
}

