/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.blob;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.web.common.ServletHelper;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.forms.FormData;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;

@WebObject(type="blob")
public class BlobObject
extends DefaultObject {
    private String fieldPath;
    private DocumentModel doc;
    private BlobHolder bh;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initialize(Object ... args) {
        super.initialize(args);
        if (args.length != 2) return;
        this.fieldPath = (String)args[0];
        this.doc = (DocumentModel)args[1];
        if (this.fieldPath == null) {
            if (this.bh != null || !this.doc.hasSchema("file")) throw new IllegalArgumentException("No xpath specified and document does not have 'file' schema");
            this.fieldPath = "file:content";
            return;
        } else {
            if (!this.fieldPath.startsWith("blobholder:")) return;
            this.bh = (BlobHolder)this.doc.getAdapter(BlobHolder.class);
            if (this.bh == null) throw new WebResourceNotFoundException("No BlobHolder found");
            this.fieldPath = this.fieldPath.replace("blobholder:", "");
        }
    }

    public <A> A getAdapter(Class<A> adapter) {
        if (adapter.isAssignableFrom(Blob.class)) {
            try {
                return adapter.cast(this.getBlob());
            }
            catch (ClientException e) {
                throw WebException.wrap((String)("Could not find any blob: " + this.fieldPath), (Throwable)e);
            }
        }
        return (A)super.getAdapter(adapter);
    }

    protected Blob getBlob() throws ClientException {
        if (this.bh != null) {
            if (StringUtils.isBlank((String)this.fieldPath) || this.fieldPath.equals("0")) {
                return this.bh.getBlob();
            }
            int index = Integer.parseInt(this.fieldPath);
            return (Blob)this.bh.getBlobs().get(index);
        }
        return (Blob)this.doc.getPropertyValue(this.fieldPath);
    }

    @GET
    public Object doGet(@Context Request request) throws ClientException {
        try {
            Blob blob = this.getBlob();
            if (blob == null) {
                throw new WebResourceNotFoundException("No attached file at " + this.fieldPath);
            }
            return blob;
        }
        catch (ClientException e) {
            throw WebException.wrap((String)"Failed to get the attached file", (Throwable)e);
        }
    }

    @Deprecated
    public static Response buildResponseFromBlob(Request request, HttpServletRequest httpServletRequest, Blob blob, String filename) {
        Response.ResponseBuilder builder;
        String digest;
        EntityTag etag;
        if (filename == null) {
            filename = blob.getFilename();
        }
        EntityTag entityTag = etag = (digest = blob.getDigest()) == null ? null : new EntityTag(digest);
        if (etag != null && (builder = request.evaluatePreconditions(etag)) != null) {
            return builder.build();
        }
        String contentDisposition = ServletHelper.getRFC2231ContentDisposition((HttpServletRequest)httpServletRequest, (String)filename);
        Response.ResponseBuilder builder2 = Response.ok((Object)blob).header("Content-Disposition", (Object)contentDisposition).type(blob.getMimeType());
        if (etag != null) {
            builder2.tag(etag);
        }
        return builder2.build();
    }

    @DELETE
    public Response doDelete() {
        try {
            if (this.bh != null) {
                throw new IllegalArgumentException("Cannot modify a Blob using a BlobHolder");
            }
            this.doc.getProperty(this.fieldPath).remove();
            CoreSession session = this.ctx.getCoreSession();
            session.saveDocument(this.doc);
            session.save();
        }
        catch (ClientException e) {
            throw WebException.wrap((String)("Failed to delete attached file into property: " + this.fieldPath), (Throwable)e);
        }
        return Response.noContent().build();
    }

    @PUT
    public Response doPut() {
        FormData form = this.ctx.getForm();
        Blob blob = form.getFirstBlob();
        if (blob == null) {
            throw new IllegalArgumentException("Could not find any uploaded file");
        }
        try {
            if (this.bh != null) {
                throw new IllegalArgumentException("Cannot modify a Blob using a BlobHolder");
            }
            this.doc.setPropertyValue(this.fieldPath, (Serializable)blob);
            this.doc.putContextData("VersioningOption", (Serializable)form.getVersioningOption());
            CoreSession session = this.ctx.getCoreSession();
            session.saveDocument(this.doc);
            session.save();
            return Response.ok((Object)"blob updated").build();
        }
        catch (ClientException e) {
            throw WebException.wrap((String)"Failed to attach file", (Throwable)e);
        }
    }
}

