/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.directory;

import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryEntry;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.restapi.server.jaxrs.directory.DirectoryObject;
import org.nuxeo.ecm.restapi.server.jaxrs.directory.DirectorySessionRunner;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="directoryEntry")
public class DirectoryEntryObject
extends DefaultObject {
    protected DirectoryEntry entry;
    protected Directory directory;

    protected void initialize(Object ... args) {
        if (args.length < 1) {
            throw new IllegalArgumentException("Directory Entry obhect  takes one parameter");
        }
        this.entry = (DirectoryEntry)args[0];
        this.directory = this.getDirectoryFromEntry(this.entry);
    }

    @GET
    public DirectoryEntry doGet() {
        return this.entry;
    }

    @PUT
    public DirectoryEntry doUpdateEntry(final DirectoryEntry entry) {
        this.checkEditGuards();
        return DirectorySessionRunner.withDirectorySession(this.directory, new DirectorySessionRunner<DirectoryEntry>(){

            @Override
            DirectoryEntry run(Session session) throws ClientException {
                DocumentModel docEntry = entry.getDocumentModel();
                session.updateEntry(docEntry);
                String id = (String)((Object)docEntry.getPropertyValue(DirectoryEntryObject.this.directory.getSchema() + ":" + DirectoryEntryObject.this.directory.getIdField()));
                return new DirectoryEntry(DirectoryEntryObject.this.directory.getName(), session.getEntry(id));
            }
        });
    }

    private void checkEditGuards() {
        ((DirectoryObject)this.prev).checkEditGuards();
    }

    @DELETE
    public Response doDeleteEntry() {
        this.checkEditGuards();
        DirectorySessionRunner.withDirectorySession(this.directory, new DirectorySessionRunner<DirectoryEntry>(){

            @Override
            DirectoryEntry run(Session session) throws ClientException {
                session.deleteEntry(DirectoryEntryObject.this.entry.getDocumentModel());
                return null;
            }
        });
        return Response.ok().status(Response.Status.NO_CONTENT).build();
    }

    private Directory getDirectoryFromEntry(DirectoryEntry entry) {
        Directory directory;
        DirectoryService ds = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        try {
            directory = ds.getDirectory(entry.getDirectoryName());
        }
        catch (DirectoryException e) {
            throw new WebResourceNotFoundException("directory not found");
        }
        return directory;
    }
}

