/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.rendition;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.rendition.Rendition;
import org.nuxeo.ecm.platform.rendition.service.RenditionService;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;
import org.nuxeo.runtime.api.Framework;

@WebAdapter(name="rendition", type="renditionAdapter")
public class RenditionAdapter
extends DefaultAdapter {
    public static final String NAME = "rendition";

    @GET
    @Path(value="{renditionName}")
    public Object doGetRendition(@Context Request request, @PathParam(value="renditionName") String renditionName) {
        DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
        RenditionService renditionService = (RenditionService)Framework.getService(RenditionService.class);
        Rendition rendition = renditionService.getRendition(doc, renditionName);
        if (rendition == null) {
            throw new WebResourceNotFoundException(String.format("No rendition '%s' was found", renditionName));
        }
        Blob blob = rendition.getBlob();
        if (blob == null) {
            throw new WebResourceNotFoundException(String.format("No Blob was found for rendition '%s'", renditionName));
        }
        return blob;
    }
}

