/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.scim.server.jaxrs.usermanager;

import javax.servlet.ServletRequest;
import javax.ws.rs.core.MediaType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.exceptions.WebSecurityException;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.scim.server.jaxrs.usermanager.SCIMUserWebObject;
import org.nuxeo.scim.server.mapper.AbstractMapper;
import org.nuxeo.scim.server.mapper.UserMapperFactory;

public abstract class BaseUMObject
extends DefaultObject {
    protected static Log log = LogFactory.getLog(SCIMUserWebObject.class);
    protected UserManager um;
    protected AbstractMapper mapper;
    protected String baseUrl;
    protected MediaType fixeMediaType = null;

    protected abstract String getPrefix();

    protected void initialize(Object ... args) {
        this.um = (UserManager)Framework.getLocalService(UserManager.class);
        this.baseUrl = VirtualHostHelper.getBaseURL((ServletRequest)WebEngine.getActiveContext().getRequest());
        while (this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl.substring(0, this.baseUrl.length() - 1);
        }
        this.baseUrl = this.baseUrl + WebEngine.getActiveContext().getUrlPath();
        int idx = this.baseUrl.lastIndexOf(this.getPrefix());
        if (idx > 0) {
            this.baseUrl = this.baseUrl.substring(0, idx + this.getPrefix().length());
        }
        this.mapper = UserMapperFactory.getMapper(this.baseUrl);
        if (args != null && args.length > 0) {
            this.fixeMediaType = (MediaType)args[0];
        }
        if (this.fixeMediaType == null) {
            String accept = WebEngine.getActiveContext().getRequest().getHeader("Accept");
            this.fixeMediaType = accept != null && accept.toLowerCase().contains("application/xml") ? MediaType.APPLICATION_XML_TYPE : MediaType.APPLICATION_JSON_TYPE;
        }
    }

    protected void checkUpdateGuardPreconditions() throws ClientException {
        NuxeoPrincipal principal = (NuxeoPrincipal)this.getContext().getCoreSession().getPrincipal();
        if (!(principal.isAdministrator() || principal.isMemberOf("powerusers") && this.isAPowerUserEditableArtifact())) {
            throw new WebSecurityException("User is not allowed to edit users");
        }
    }

    protected boolean isAPowerUserEditableArtifact() {
        return false;
    }
}

