/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.scim.server.mapper;

import com.unboundid.scim.data.Meta;
import com.unboundid.scim.data.UserResource;
import com.unboundid.scim.schema.CoreSchema;
import java.net.URI;
import java.util.HashMap;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.scim.server.mapper.AbstractMapper;
import org.nuxeo.usermapper.service.UserMapperService;

public class ConfigurableUserMapper
extends AbstractMapper {
    protected UserMapperService mapperService = (UserMapperService)Framework.getService(UserMapperService.class);
    protected static final String MAPPING_NAME = "scim";

    public ConfigurableUserMapper(String baseUrl) {
        super(baseUrl);
    }

    @Override
    public UserResource getUserResourceFromNuxeoUser(DocumentModel userModel) throws Exception {
        UserResource userResource = new UserResource(CoreSchema.USER_DESCRIPTOR);
        String userId = (String)userModel.getProperty(this.um.getUserSchemaName(), this.um.getUserIdField());
        userResource.setUserName(userId);
        userResource.setId(userId);
        userResource.setExternalId(userId);
        NuxeoPrincipal principal = this.um.getPrincipal(userId);
        URI location = new URI(this.baseUrl + "/" + userId);
        Meta meta = new Meta(null, null, location, "1");
        userResource.setMeta(meta);
        return (UserResource)this.mapperService.wrapNuxeoPrincipal(MAPPING_NAME, principal, (Object)userResource, null);
    }

    @Override
    public DocumentModel createNuxeoUserFromUserResource(UserResource user) throws NuxeoException {
        NuxeoPrincipal principal = this.mapperService.getOrCreateAndUpdateNuxeoPrincipal(MAPPING_NAME, (Object)user, true, true, null);
        if (principal != null) {
            return this.um.getUserModel(principal.getName());
        }
        return null;
    }

    @Override
    public DocumentModel updateNuxeoUserFromUserResource(String uid, UserResource user) throws NuxeoException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uid", uid);
        NuxeoPrincipal principal = this.mapperService.getOrCreateAndUpdateNuxeoPrincipal(MAPPING_NAME, (Object)user, false, true, params);
        if (principal != null) {
            return this.um.getUserModel(principal.getName());
        }
        return null;
    }
}

