/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.scim.server.mapper;

import com.unboundid.scim.data.Entry;
import com.unboundid.scim.data.Meta;
import com.unboundid.scim.data.Name;
import com.unboundid.scim.data.UserResource;
import com.unboundid.scim.schema.CoreSchema;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.scim.server.mapper.AbstractMapper;

public class StaticUserMapper
extends AbstractMapper {
    public StaticUserMapper(String baseUrl) {
        super(baseUrl);
    }

    @Override
    public UserResource getUserResourceFromNuxeoUser(DocumentModel userModel) throws Exception {
        UserResource userResource = new UserResource(CoreSchema.USER_DESCRIPTOR);
        String userId = (String)userModel.getProperty(this.um.getUserSchemaName(), this.um.getUserIdField());
        userResource.setUserName(userId);
        userResource.setId(userId);
        userResource.setExternalId(userId);
        String fname = (String)userModel.getProperty(this.um.getUserSchemaName(), "firstName");
        String lname = (String)userModel.getProperty(this.um.getUserSchemaName(), "lastName");
        String email = (String)userModel.getProperty(this.um.getUserSchemaName(), "email");
        String company = (String)userModel.getProperty(this.um.getUserSchemaName(), "company");
        String displayName = fname + " " + lname;
        displayName = displayName.trim();
        userResource.setDisplayName(displayName);
        ArrayList<Entry> emails = new ArrayList<Entry>();
        if (email != null) {
            emails.add(new Entry((Object)email, "string"));
            userResource.setEmails(emails);
        }
        Name fullName = new Name(displayName, lname, "", fname, "", "");
        userResource.setSingularAttributeValue("urn:scim:schemas:core:1.0", "name", Name.NAME_RESOLVER, (Object)fullName);
        URI location = new URI(this.baseUrl + "/" + userId);
        Meta meta = new Meta(null, null, location, "1");
        userResource.setMeta(meta);
        List groupIds = this.um.getPrincipal(userId).getAllGroups();
        ArrayList<Entry> groups = new ArrayList<Entry>();
        for (String groupId : groupIds) {
            groups.add(new Entry((Object)groupId, "string"));
        }
        userResource.setGroups(groups);
        userResource.setActive(Boolean.valueOf(true));
        return userResource;
    }

    @Override
    public DocumentModel createNuxeoUserFromUserResource(UserResource user) throws NuxeoException {
        DocumentModel newUser = this.um.getBareUserModel();
        String userId = user.getId();
        if (userId == null || userId.isEmpty()) {
            userId = user.getUserName();
        }
        newUser.setProperty(this.um.getUserSchemaName(), this.um.getUserIdField(), (Object)userId);
        this.updateUserModel(newUser, user);
        return this.um.createUser(newUser);
    }

    @Override
    public DocumentModel updateNuxeoUserFromUserResource(String uid, UserResource user) throws NuxeoException {
        DocumentModel userModel = this.um.getUserModel(uid);
        if (userModel == null) {
            return null;
        }
        this.updateUserModel(userModel, user);
        this.um.updateUser(userModel);
        return userModel;
    }

    protected void updateUserModel(DocumentModel userModel, UserResource userResouce) throws NuxeoException {
        String displayName;
        if (userResouce.getEmails() != null && userResouce.getEmails().size() > 0) {
            userModel.setProperty(this.um.getUserSchemaName(), "email", ((Entry)userResouce.getEmails().iterator().next()).getValue());
        }
        if ((displayName = userResouce.getDisplayName()) != null && !displayName.isEmpty()) {
            int idx = displayName.indexOf(" ");
            if (idx > 0) {
                userModel.setProperty(this.um.getUserSchemaName(), "firstName", (Object)displayName.substring(0, idx).trim());
                userModel.setProperty(this.um.getUserSchemaName(), "lastName", (Object)displayName.substring(idx + 1).trim());
            } else {
                userModel.setProperty(this.um.getUserSchemaName(), "firstName", (Object)displayName);
                userModel.setProperty(this.um.getUserSchemaName(), "lastName", (Object)"");
            }
        }
    }
}

