/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.search;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.automation.server.jaxrs.RestOperationException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.platform.query.api.QuickFilter;
import org.nuxeo.ecm.platform.search.core.InvalidSearchParameterException;
import org.nuxeo.ecm.platform.search.core.SavedSearch;
import org.nuxeo.ecm.platform.search.core.SavedSearchRequest;
import org.nuxeo.ecm.platform.search.core.SavedSearchService;
import org.nuxeo.ecm.restapi.server.jaxrs.search.QueryExecutor;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="search")
public class SearchObject
extends QueryExecutor {
    private static final String APPLICATION_JSON_NXENTITY = "application/json+nxentity";
    public static final String SAVED_SEARCHES_PAGE_PROVIDER = "SAVED_SEARCHES_ALL";
    public static final String SAVED_SEARCHES_PAGE_PROVIDER_PARAMS = "SAVED_SEARCHES_ALL_PAGE_PROVIDER";
    public static final String PAGE_PROVIDER_NAME_PARAM = "pageProvider";
    protected SavedSearchService savedSearchService;

    public void initialize(Object ... args) {
        this.initExecutor();
        this.savedSearchService = (SavedSearchService)Framework.getService(SavedSearchService.class);
    }

    @GET
    @Path(value="lang/{queryLanguage}/execute")
    public Object doQueryByLang(@Context UriInfo uriInfo, @PathParam(value="queryLanguage") String queryLanguage) throws RestOperationException {
        MultivaluedMap queryParams = uriInfo.getQueryParameters();
        return this.queryByLang(queryLanguage, (MultivaluedMap<String, String>)queryParams);
    }

    @GET
    @Path(value="pp/{pageProviderName}/execute")
    public Object doQueryByPageProvider(@Context UriInfo uriInfo, @PathParam(value="pageProviderName") String pageProviderName) throws RestOperationException {
        MultivaluedMap queryParams = uriInfo.getQueryParameters();
        return this.queryByPageProvider(pageProviderName, (MultivaluedMap<String, String>)queryParams);
    }

    @GET
    @Path(value="pp/{pageProviderName}")
    public Object doGetPageProviderDefinition(@PathParam(value="pageProviderName") String pageProviderName) throws RestOperationException, IOException {
        return this.buildResponse((Response.StatusType)Response.Status.OK, "application/json", this.getPageProviderDefinition(pageProviderName));
    }

    @GET
    @Path(value="saved")
    public List<SavedSearch> doGetSavedSearches(@Context UriInfo uriInfo) throws RestOperationException {
        MultivaluedMap queryParams = uriInfo.getQueryParameters();
        DocumentModelList results = queryParams.containsKey((Object)PAGE_PROVIDER_NAME_PARAM) ? this.queryByPageProvider(SAVED_SEARCHES_PAGE_PROVIDER_PARAMS, (MultivaluedMap<String, String>)queryParams) : this.queryByPageProvider(SAVED_SEARCHES_PAGE_PROVIDER, (MultivaluedMap<String, String>)queryParams);
        ArrayList<SavedSearch> savedSearches = new ArrayList<SavedSearch>(results.size());
        for (DocumentModel doc : results) {
            savedSearches.add((SavedSearch)doc.getAdapter(SavedSearch.class));
        }
        return savedSearches;
    }

    @POST
    @Path(value="saved")
    @Consumes(value={"application/json+nxentity", "application/json"})
    public Response doSaveSearch(SavedSearchRequest request) throws RestOperationException {
        try {
            SavedSearch search = this.savedSearchService.createSavedSearch(this.ctx.getCoreSession(), request.getTitle(), request.getQueryParams(), null, request.getQuery(), request.getQueryLanguage(), request.getPageProviderName(), request.getPageSize(), request.getCurrentPageIndex(), request.getMaxResults(), request.getSortBy(), request.getSortOrder(), request.getContentViewData());
            this.setSaveSearchParams(request.getNamedParams(), search);
            return Response.ok((Object)this.savedSearchService.saveSavedSearch(this.ctx.getCoreSession(), search)).build();
        }
        catch (IOException | InvalidSearchParameterException e) {
            RestOperationException err = new RestOperationException(e.getMessage());
            err.setStatus(400);
            throw err;
        }
    }

    @GET
    @Path(value="saved/{id}")
    public Response doGetSavedSearch(@PathParam(value="id") String id) throws RestOperationException {
        SavedSearch search;
        try {
            search = this.savedSearchService.getSavedSearch(this.ctx.getCoreSession(), id);
        }
        catch (DocumentNotFoundException e) {
            RestOperationException err = new RestOperationException("unknown id: " + e.getMessage());
            err.setStatus(404);
            throw err;
        }
        if (search == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)search).build();
    }

    @PUT
    @Path(value="saved/{id}")
    @Consumes(value={"application/json+nxentity", "application/json"})
    public Response doUpdateSavedSearch(SavedSearchRequest request, @PathParam(value="id") String id) throws RestOperationException {
        SavedSearch search;
        try {
            search = this.savedSearchService.getSavedSearch(this.ctx.getCoreSession(), id);
        }
        catch (DocumentNotFoundException e) {
            RestOperationException err = new RestOperationException("unknown id: " + e.getMessage());
            err.setStatus(404);
            throw err;
        }
        if (search == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        search.setTitle(request.getTitle());
        search.setQueryParams(request.getQueryParams());
        search.setQuery(request.getQuery());
        search.setQueryLanguage(request.getQueryLanguage());
        search.setPageProviderName(request.getPageProviderName());
        search.setPageSize(request.getPageSize());
        search.setCurrentPageIndex(request.getCurrentPageIndex());
        search.setMaxResults(request.getMaxResults());
        search.setSortBy(request.getSortBy());
        search.setSortOrder(request.getSortOrder());
        search.setContentViewData(request.getContentViewData());
        try {
            this.setSaveSearchParams(request.getNamedParams(), search);
            search = this.savedSearchService.saveSavedSearch(this.ctx.getCoreSession(), search);
        }
        catch (IOException | InvalidSearchParameterException e) {
            RestOperationException err = new RestOperationException(e.getMessage());
            err.setStatus(400);
            throw err;
        }
        return Response.ok((Object)search).build();
    }

    @DELETE
    @Path(value="saved/{id}")
    public Response doDeleteSavedSearch(@PathParam(value="id") String id) throws RestOperationException {
        try {
            SavedSearch search = this.savedSearchService.getSavedSearch(this.ctx.getCoreSession(), id);
            this.savedSearchService.deleteSavedSearch(this.ctx.getCoreSession(), search);
        }
        catch (DocumentNotFoundException e) {
            RestOperationException err = new RestOperationException(e.getMessage());
            err.setStatus(404);
            throw err;
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @GET
    @Path(value="saved/{id}/execute")
    public Object doExecuteSavedSearch(@PathParam(value="id") String id, @Context UriInfo uriInfo) throws RestOperationException {
        MultivaluedMap params = uriInfo.getQueryParameters();
        SavedSearch search = this.savedSearchService.getSavedSearch(this.ctx.getCoreSession(), id);
        if (search == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return this.executeSavedSearch(search, (MultivaluedMap<String, String>)params);
    }

    protected void setSaveSearchParams(Map<String, String> params, SavedSearch search) throws IOException {
        HashMap<String, String> namedParams = new HashMap<String, String>();
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                try {
                    Property prop = search.getDocument().getProperty(key);
                    DocumentHelper.setProperty((CoreSession)search.getDocument().getCoreSession(), (DocumentModel)search.getDocument(), (String)key, (String)value, (boolean)true);
                }
                catch (PropertyNotFoundException e) {
                    namedParams.put(key, value);
                }
            }
        }
        search.setNamedParams(namedParams);
    }

    protected DocumentModelList executeSavedSearch(SavedSearch search, MultivaluedMap<String, String> params) throws RestOperationException {
        Long pageSize = this.getPageSize(params);
        Long currentPageIndex = this.getCurrentPageIndex(params);
        Long maxResults = this.getMaxResults(params);
        List<SortInfo> sortInfo = this.getSortInfo(params);
        if (!StringUtils.isEmpty((String)search.getPageProviderName())) {
            List<QuickFilter> quickFilters = this.getQuickFilters(search.getPageProviderName(), params);
            return this.querySavedSearchByPageProvider(search.getPageProviderName(), pageSize != null ? pageSize : search.getPageSize(), currentPageIndex != null ? currentPageIndex : search.getCurrentPageIndex(), search.getQueryParams(), search.getNamedParams(), sortInfo != null ? sortInfo : this.getSortInfo(search.getSortBy(), search.getSortOrder()), quickFilters, search.getDocument().getType() != "SavedSearch" ? search.getDocument() : null);
        }
        if (!StringUtils.isEmpty((String)search.getQuery()) && !StringUtils.isEmpty((String)search.getQueryLanguage())) {
            return this.querySavedSearchByLang(search.getQueryLanguage(), search.getQuery(), pageSize != null ? pageSize : search.getPageSize(), currentPageIndex != null ? currentPageIndex : search.getCurrentPageIndex(), maxResults != null ? maxResults : search.getMaxResults(), search.getQueryParams(), search.getNamedParams(), sortInfo != null ? sortInfo : this.getSortInfo(search.getSortBy(), search.getSortOrder()));
        }
        return null;
    }

    protected DocumentModelList querySavedSearchByLang(String queryLanguage, String query, Long pageSize, Long currentPageIndex, Long maxResults, String orderedParams, Map<String, String> namedParameters, List<SortInfo> sortInfo) throws RestOperationException {
        Properties namedParametersProps = this.getNamedParameters(namedParameters);
        Object[] parameters = this.replaceParameterPattern(new Object[]{orderedParams});
        Map<String, Serializable> props = this.getProperties();
        DocumentModel searchDocumentModel = this.getSearchDocumentModel(this.ctx.getCoreSession(), this.pageProviderService, null, namedParametersProps);
        return this.queryByLang(query, pageSize, currentPageIndex, maxResults, sortInfo, parameters, props, searchDocumentModel);
    }

    protected DocumentModelList querySavedSearchByPageProvider(String pageProviderName, Long pageSize, Long currentPageIndex, String orderedParams, Map<String, String> namedParameters, List<SortInfo> sortInfo, List<QuickFilter> quickFilters, DocumentModel searchDocumentModel) throws RestOperationException {
        DocumentModel documentModel;
        Properties namedParametersProps = this.getNamedParameters(namedParameters);
        Object[] parameters = orderedParams != null ? this.replaceParameterPattern(new Object[]{orderedParams}) : new Object[]{};
        Map<String, Serializable> props = this.getProperties();
        if (searchDocumentModel == null) {
            documentModel = this.getSearchDocumentModel(this.ctx.getCoreSession(), this.pageProviderService, pageProviderName, namedParametersProps);
        } else {
            documentModel = searchDocumentModel;
            if (namedParametersProps.size() > 0) {
                documentModel.putContextData("namedParameters", (Serializable)namedParametersProps);
            }
        }
        return this.queryByPageProvider(pageProviderName, pageSize, currentPageIndex, sortInfo, quickFilters, parameters, props, documentModel);
    }
}

