/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.jsf.facelets;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.TemplateClient;
import com.sun.facelets.el.VariableMapperWrapper;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagHandler;
import com.sun.facelets.tag.ui.DefineHandler;
import com.sun.facelets.tag.ui.ParamHandler;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.el.ELException;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.theme.ApplicationType;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.NegotiationDef;
import org.nuxeo.theme.jsf.negotiation.JSFNegotiator;
import org.nuxeo.theme.negotiation.NegotiationException;
import org.nuxeo.theme.types.TypeFamily;

public final class CompositionHandler
extends TagHandler
implements TemplateClient {
    private static final Log log = LogFactory.getLog(CompositionHandler.class);
    public static final String Name = "theme";
    protected final Map<String, DefineHandler> handlers = new HashMap<String, DefineHandler>();
    protected final TagAttribute strategyAttribute;
    protected final ParamHandler[] params;

    public CompositionHandler(TagConfig config) {
        super(config);
        Iterator itr = this.findNextByType(DefineHandler.class);
        DefineHandler d = null;
        while (itr.hasNext()) {
            d = (DefineHandler)itr.next();
            this.handlers.put(d.getName(), d);
            log.debug((Object)(this.tag + " found Define[" + d.getName() + "]"));
        }
        ArrayList paramC = new ArrayList();
        itr = this.findNextByType(ParamHandler.class);
        while (itr.hasNext()) {
            paramC.add(itr.next());
        }
        if (paramC.size() > 0) {
            this.params = new ParamHandler[paramC.size()];
            for (int i = 0; i < this.params.length; ++i) {
                this.params[i] = (ParamHandler)paramC.get(i);
            }
        } else {
            this.params = null;
        }
        this.strategyAttribute = this.getAttribute("strategy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        VariableMapper orig = ctx.getVariableMapper();
        if (this.params != null) {
            VariableMapperWrapper vm = new VariableMapperWrapper(orig);
            ctx.setVariableMapper((VariableMapper)vm);
            for (int i = 0; i < this.params.length; ++i) {
                this.params[i].apply(ctx, parent);
            }
        }
        ctx.extendClient((TemplateClient)this);
        try {
            NegotiationDef negotiation;
            FacesContext facesContext = ctx.getFacesContext();
            ExternalContext external = facesContext.getExternalContext();
            Map requestMap = external.getRequestMap();
            String root = external.getRequestContextPath();
            ApplicationType application = (ApplicationType)Manager.getTypeRegistry().lookup(TypeFamily.APPLICATION, root);
            String strategy = null;
            if (application != null && (negotiation = application.getNegotiation()) != null) {
                requestMap.put("org.nuxeo.theme.default.theme", negotiation.getDefaultTheme());
                requestMap.put("org.nuxeo.theme.default.engine", negotiation.getDefaultEngine());
                requestMap.put("org.nuxeo.theme.default.perspective", negotiation.getDefaultPerspective());
                strategy = negotiation.getStrategy();
            }
            if (this.strategyAttribute != null) {
                strategy = this.strategyAttribute.getValue(ctx);
            }
            String contextPath = BaseURL.getContextPath() + "/site";
            if (strategy == null) {
                log.error((Object)("Could not obtain the negotiation strategy for " + root));
                external.redirect(contextPath + "/nxthemes/error/negotiationStrategyNotSet.faces");
            } else {
                try {
                    String spec = new JSFNegotiator(strategy, facesContext).getSpec();
                    URL themeUrl = new URL(spec);
                    requestMap.put("org.nuxeo.theme.url", themeUrl);
                    ctx.includeFacelet(parent, themeUrl);
                }
                catch (NegotiationException e) {
                    log.error((Object)"Could not get default negotiation settings.", (Throwable)e);
                    external.redirect(contextPath + "/nxthemes/error/negotiationDefaultValuesNotSet.faces");
                }
            }
        }
        finally {
            ctx.popClient((TemplateClient)this);
            ctx.setVariableMapper(orig);
        }
    }

    public boolean apply(FaceletContext ctx, UIComponent parent, String name) throws IOException, FacesException, FaceletException, ELException {
        if (name != null) {
            if (this.handlers == null) {
                return false;
            }
            DefineHandler handler = this.handlers.get(name);
            if (handler != null) {
                handler.applyDefinition(ctx, parent);
                return true;
            }
            return false;
        }
        this.nextHandler.apply(ctx, parent);
        return true;
    }

    static {
        Manager.initializeProtocols();
    }
}

