/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.webwidgets.ui;

import java.net.URL;
import java.util.HashMap;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.html.Utils;
import org.nuxeo.theme.rendering.RenderingInfo;
import org.nuxeo.theme.resources.ResourceManager;
import org.nuxeo.theme.views.AbstractView;
import org.nuxeo.theme.webwidgets.DecorationType;
import org.nuxeo.theme.webwidgets.ProviderType;
import org.nuxeo.theme.webwidgets.RegionModel;

public final class PanelView
extends AbstractView {
    public String render(RenderingInfo info) {
        RegionModel region = (RegionModel)info.getModel();
        String regionName = region.name;
        String providerName = region.provider;
        String decorationName = region.decoration;
        String engineName = info.getEngine().getName();
        String viewMode = info.getViewMode();
        int areaUid = info.getElement().getUid();
        String displayedRegionName = regionName.equals("") ? "&lt;Please set the region name&gt;" : regionName;
        URL themeUrl = info.getThemeUrl();
        ResourceManager resourceManager = Manager.getResourceManager();
        DecorationType decorationType = org.nuxeo.theme.webwidgets.Manager.getDecorationType((String)decorationName);
        for (String resource : decorationType.getResources()) {
            resourceManager.addResource(resource, themeUrl);
        }
        StringBuilder s = new StringBuilder();
        if (engineName.equals("page-editor")) {
            ProviderType providerType = org.nuxeo.theme.webwidgets.Manager.getProviderType((String)providerName);
            String description = "";
            if (providerType != null) {
                description = providerType.getDescription();
            }
            s.append("<div class=\"nxthemesPageArea\">");
            s.append(String.format("<div class=\"title\">%s</div>", displayedRegionName));
            s.append(String.format("<div class=\"body\">Web widget area. <p>Provider: <strong>%s</strong> (%s)</p></div>", providerName, description));
            s.append("</div>");
        } else if (engineName.equals("fragments-only")) {
            String content = "&lt;PANEL AREA&gt;<div class=\"nxthemesWebWidget\">&lt;WEB WIDGET&gt;</div>";
            String panelContent = org.nuxeo.theme.webwidgets.Manager.addPanelDecoration((String)decorationName, (String)"*", (String)displayedRegionName, (String)"&lt;PANEL AREA&gt;<div class=\"nxthemesWebWidget\">&lt;WEB WIDGET&gt;</div>");
            s.append(String.format("<div>%s</div>", panelContent));
        } else if (viewMode.equals("web-widgets")) {
            StringBuilder sb = new StringBuilder();
            if (!regionName.equals("")) {
                String identifier = String.format("web widget panel %s", info.getUid());
                String model = String.format("{\"data\":{\"area\":\"%s\",\"provider\":\"%s\",\"decoration\":\"%s\",\"mode\":\"%s\"},\"id\":\"%s\"}", areaUid, providerName, decorationName, viewMode, identifier);
                String view = String.format("{\"controllers\":[\"web widget perspectives\",\"web widget inserter\",\"web widget mover\"],\"widget\":{\"type\":\"web widget panel\"},\"model\":\"%s\",\"perspectives\":[\"default\"],\"id\":\"%s\"}", identifier, identifier);
                sb.append(String.format("<ins class=\"model\">%s</ins>", model));
                sb.append(String.format("<ins class=\"view\">%s</ins>", view));
            }
            s.append(org.nuxeo.theme.webwidgets.Manager.addPanelDecoration((String)decorationName, (String)viewMode, (String)displayedRegionName, (String)sb.toString()));
        } else if (!regionName.equals("")) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("area", areaUid);
            data.put("mode", viewMode);
            String content = String.format("<ins style=\"display: none\" class=\"nxthemesWebWidgetPanel\">%s</ins>", Utils.toJson(data));
            s.append(String.format("<div>%s</div>", org.nuxeo.theme.webwidgets.Manager.addPanelDecoration((String)decorationName, (String)viewMode, (String)displayedRegionName, (String)content)));
        }
        return s.toString();
    }
}

