/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.webwidgets.providers;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.persistence.HibernateConfiguration;
import org.nuxeo.ecm.core.persistence.HibernateConfigurator;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.theme.webwidgets.Provider;
import org.nuxeo.theme.webwidgets.ProviderException;
import org.nuxeo.theme.webwidgets.Widget;
import org.nuxeo.theme.webwidgets.WidgetData;
import org.nuxeo.theme.webwidgets.WidgetState;
import org.nuxeo.theme.webwidgets.providers.DataEntity;
import org.nuxeo.theme.webwidgets.providers.WidgetEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentProvider
implements Provider {
    private static final Log log = LogFactory.getLog(PersistentProvider.class);
    protected EntityManager em = new UnsupportedEntityManager();
    protected EntityTransaction et;

    @Override
    public void activate() {
        HibernateConfigurator configurator;
        try {
            configurator = (HibernateConfigurator)Framework.getService(HibernateConfigurator.class);
        }
        catch (Exception e) {
            log.error((Object)"No hibernate configurator available, aborting", (Throwable)e);
            return;
        }
        HibernateConfiguration config = configurator.getHibernateConfiguration("nxwebwidgets");
        this.em = config.getFactory(HibernateConfiguration.RESOURCE_LOCAL).createEntityManager();
    }

    public Principal getCurrentPrincipal() {
        WebContext ctx = WebEngine.getActiveContext();
        if (ctx != null) {
            return ctx.getPrincipal();
        }
        return null;
    }

    @Override
    public void addWidget(Widget widget, String regionName, int order) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        if (regionName == null) {
            throw new ProviderException("Region name is undefined");
        }
        ArrayList<Widget> widgets = new ArrayList<Widget>(this.getWidgets(regionName));
        ((WidgetEntity)widget).setRegion(regionName);
        widgets.add(order, widget);
        this.reorderWidgets(widgets);
    }

    @Override
    public synchronized Widget createWidget(String widgetTypeName) throws ProviderException {
        if (widgetTypeName == null) {
            throw new ProviderException("Widget type name is undefined");
        }
        WidgetEntity widget = new WidgetEntity(widgetTypeName);
        this.begin();
        this.em.persist((Object)widget);
        this.commit();
        return widget;
    }

    @Override
    public String getRegionOfWidget(Widget widget) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        return ((WidgetEntity)widget).getRegion();
    }

    @Override
    public WidgetState getWidgetState(Widget widget) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        return ((WidgetEntity)widget).getState();
    }

    @Override
    public synchronized Widget getWidgetByUid(String uid) throws ProviderException {
        Widget widget = (Widget)this.em.find(WidgetEntity.class, (Object)Integer.valueOf(uid));
        if (widget == null) {
            throw new ProviderException("Widget not found: " + uid);
        }
        return widget;
    }

    @Override
    public synchronized List<Widget> getWidgets(String regionName) throws ProviderException {
        if (regionName == null) {
            throw new ProviderException("Region name is undefined.");
        }
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.addAll(this.em.createNamedQuery("Widget.findAll").setParameter("region", (Object)regionName).getResultList());
        return widgets;
    }

    @Override
    public void moveWidget(Widget widget, String destRegionName, int order) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        if (destRegionName == null) {
            throw new ProviderException("Destination region name is undefined.");
        }
        WidgetEntity widgetEntity = (WidgetEntity)widget;
        String srcRegionName = widgetEntity.getRegion();
        ArrayList<Widget> srcWidgets = new ArrayList<Widget>(this.getWidgets(srcRegionName));
        srcWidgets.remove(widgetEntity.getOrder());
        this.reorderWidgets(srcWidgets);
        widgetEntity.setRegion(null);
        ArrayList<Widget> destWidgets = new ArrayList<Widget>(this.getWidgets(destRegionName));
        widgetEntity.setRegion(destRegionName);
        destWidgets.add(order, widgetEntity);
        this.reorderWidgets(destWidgets);
    }

    @Override
    public synchronized void removeWidget(Widget widget) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        WidgetEntity widgetEntity = (WidgetEntity)widget;
        ArrayList<Widget> widgets = new ArrayList<Widget>(this.getWidgets(widgetEntity.getRegion()));
        widgets.remove(widgetEntity.getOrder());
        this.reorderWidgets(widgets);
        this.begin();
        this.em.remove((Object)widget);
        this.commit();
    }

    public void removeWidgets() throws ProviderException {
        this.begin();
        Query query = this.em.createNamedQuery("Widget.removeAll");
        query.executeUpdate();
        this.commit();
    }

    @Override
    public void reorderWidget(Widget widget, int order) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        WidgetEntity widgetEntity = (WidgetEntity)widget;
        ArrayList<Widget> widgets = new ArrayList<Widget>(this.getWidgets(widgetEntity.getRegion()));
        widgets.remove(widgetEntity.getOrder());
        widgets.add(order, widgetEntity);
        this.reorderWidgets(widgets);
    }

    @Override
    public Map<String, String> getWidgetPreferences(Widget widget) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        return ((WidgetEntity)widget).getPreferences();
    }

    @Override
    public void setWidgetPreferences(Widget widget, Map<String, String> preferences) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        if (preferences == null) {
            throw new ProviderException("Widget preferences are undefined");
        }
        this.begin();
        ((WidgetEntity)widget).setPreferences(preferences);
        this.commit();
    }

    @Override
    public void setWidgetState(Widget widget, WidgetState state) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        if (state == null) {
            throw new ProviderException("Widget state is undefined");
        }
        this.begin();
        ((WidgetEntity)widget).setState(state);
        this.em.persist((Object)widget);
        this.commit();
    }

    protected synchronized void reorderWidgets(List<Widget> widgets) {
        int i = 0;
        this.begin();
        for (Widget w : widgets) {
            this.em.merge((Object)w);
            ((WidgetEntity)w).setOrder(i);
            ++i;
        }
        this.commit();
    }

    @Override
    public synchronized WidgetData getWidgetData(Widget widget, String dataName) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        if (dataName == null || "".equals(dataName)) {
            throw new ProviderException("Data name is undefined");
        }
        List results = this.em.createNamedQuery("Data.findByWidgetAndName").setParameter("widgetUid", (Object)widget.getUid()).setParameter("dataName", (Object)dataName).getResultList();
        if (results.size() > 0) {
            DataEntity dataEntity = (DataEntity)results.get(0);
            return dataEntity.getData();
        }
        return null;
    }

    @Override
    public synchronized void setWidgetData(Widget widget, String dataName, WidgetData data) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        if (dataName == null || "".equals(dataName)) {
            throw new ProviderException("Data name is undefined");
        }
        List results = this.em.createNamedQuery("Data.findByWidgetAndName").setParameter("widgetUid", (Object)widget.getUid()).setParameter("dataName", (Object)dataName).getResultList();
        DataEntity dataEntity = null;
        dataEntity = results.size() > 0 ? (DataEntity)results.get(0) : new DataEntity(widget.getUid(), dataName);
        dataEntity.setData(data);
        this.begin();
        this.em.persist((Object)dataEntity);
        this.commit();
    }

    @Override
    public synchronized void deleteWidgetData(Widget widget) throws ProviderException {
        if (widget == null) {
            throw new ProviderException("Widget is undefined");
        }
        this.begin();
        for (Object dataEntity : this.em.createNamedQuery("Data.findByWidget").setParameter("widgetUid", (Object)widget.getUid()).getResultList()) {
            this.em.remove(dataEntity);
        }
        this.commit();
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        Principal currentNuxeoPrincipal = this.getCurrentPrincipal();
        if (currentNuxeoPrincipal == null) {
            log.warn((Object)"Could not get the current user from the context.");
            return false;
        }
        return ((NuxeoPrincipal)currentNuxeoPrincipal).isMemberOf("administrators");
    }

    protected void begin() {
        if (this.et != null) {
            log.warn((Object)"transaction begin called twice");
        }
        this.et = this.em.getTransaction();
        if (!this.et.isActive()) {
            this.et.begin();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commit() {
        try {
            if (this.et != null && this.et.isActive()) {
                this.et.commit();
            }
        }
        finally {
            this.et = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnsupportedEntityManager
    implements EntityManager {
        private UnsupportedEntityManager() {
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object arg0) {
            throw new UnsupportedOperationException();
        }

        public Query createNamedQuery(String arg0) {
            throw new UnsupportedOperationException();
        }

        public Query createNativeQuery(String arg0) {
            throw new UnsupportedOperationException();
        }

        public Query createNativeQuery(String arg0, Class arg1) {
            throw new UnsupportedOperationException();
        }

        public Query createNativeQuery(String arg0, String arg1) {
            throw new UnsupportedOperationException();
        }

        public Query createQuery(String arg0) {
            throw new UnsupportedOperationException();
        }

        public <T> T find(Class<T> arg0, Object arg1) {
            throw new UnsupportedOperationException();
        }

        public void flush() {
            throw new UnsupportedOperationException();
        }

        public Object getDelegate() {
            throw new UnsupportedOperationException();
        }

        public FlushModeType getFlushMode() {
            throw new UnsupportedOperationException();
        }

        public <T> T getReference(Class<T> arg0, Object arg1) {
            throw new UnsupportedOperationException();
        }

        public EntityTransaction getTransaction() {
            throw new UnsupportedOperationException();
        }

        public boolean isOpen() {
            throw new UnsupportedOperationException();
        }

        public void joinTransaction() {
            throw new UnsupportedOperationException();
        }

        public void lock(Object arg0, LockModeType arg1) {
            throw new UnsupportedOperationException();
        }

        public <T> T merge(T arg0) {
            throw new UnsupportedOperationException();
        }

        public void persist(Object arg0) {
            throw new UnsupportedOperationException();
        }

        public void refresh(Object arg0) {
            throw new UnsupportedOperationException();
        }

        public void remove(Object arg0) {
            throw new UnsupportedOperationException();
        }

        public void setFlushMode(FlushModeType arg0) {
            throw new UnsupportedOperationException();
        }
    }
}

