/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.webwidgets.providers;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.theme.webwidgets.ProviderException;
import org.nuxeo.theme.webwidgets.Widget;
import org.nuxeo.theme.webwidgets.providers.PersistentProvider;
import org.nuxeo.theme.webwidgets.providers.WidgetEntity;

public class PersistentProviderPerUser
extends PersistentProvider {
    private static final Log log = LogFactory.getLog(PersistentProviderPerUser.class);

    @Override
    public synchronized Widget createWidget(String widgetTypeName) throws ProviderException {
        if (widgetTypeName == null) {
            throw new ProviderException("Widget type name is undefined");
        }
        Principal currentNuxeoPrincipal = this.getCurrentPrincipal();
        if (currentNuxeoPrincipal == null) {
            log.warn((Object)"Could not get the current user from the context.");
            return null;
        }
        WidgetEntity widget = new WidgetEntity(widgetTypeName);
        widget.setScope(currentNuxeoPrincipal.getName());
        this.begin();
        this.em.persist((Object)widget);
        this.commit();
        return widget;
    }

    @Override
    public synchronized List<Widget> getWidgets(String regionName) throws ProviderException {
        if (regionName == null) {
            throw new ProviderException("Region name is undefined");
        }
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        Principal currentNuxeoPrincipal = this.getCurrentPrincipal();
        if (currentNuxeoPrincipal != null) {
            widgets.addAll(this.em.createNamedQuery("Widget.findByScope").setParameter("region", (Object)regionName).setParameter("scope", (Object)currentNuxeoPrincipal.getName()).getResultList());
        }
        return widgets;
    }

    @Override
    public boolean canRead() {
        Principal currentNuxeoPrincipal = this.getCurrentPrincipal();
        if (currentNuxeoPrincipal == null) {
            log.warn((Object)"Could not get the current user from the context.");
            return false;
        }
        return !((NuxeoPrincipal)currentNuxeoPrincipal).isAnonymous();
    }

    @Override
    public boolean canWrite() {
        Principal currentNuxeoPrincipal = this.getCurrentPrincipal();
        if (currentNuxeoPrincipal == null) {
            log.warn((Object)"Could not get the current user from the context.");
            return false;
        }
        return !((NuxeoPrincipal)currentNuxeoPrincipal).isAnonymous();
    }
}

