/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.webwidgets;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.webwidgets.WidgetFieldType;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);
    static final Pattern bodyPattern = Pattern.compile("<body.*?>(.*?)</body>", 34);
    static final Pattern scriptPattern = Pattern.compile("<script.*?>(.*?)</script>", 34);
    static final Pattern stylePattern = Pattern.compile("<style.*?>(.*?)</style>", 34);
    static final Pattern preferencesPattern = Pattern.compile("<widget:preferences>(.*?)</widget:preferences>", 34);
    static final Pattern metadataPattern = Pattern.compile("<meta name=\"([^\"]+)\" content=\"(.*?)\" />", 34);
    static final Pattern iconPattern = Pattern.compile("<link.*?rel=\"icon\".*?href=\"([^\"]+)\".*? />", 34);

    private Utils() {
    }

    public static String extractBody(String html) {
        Matcher matcher = bodyPattern.matcher(html);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return html;
    }

    public static String extractScripts(String html) {
        Matcher matcher = scriptPattern.matcher(html);
        StringBuilder scripts = new StringBuilder();
        while (matcher.find()) {
            String before = html.substring(0, matcher.start());
            String after = html.substring(matcher.end());
            if (!before.contains("<head>") || !after.contains("</head>")) continue;
            scripts.append(matcher.group(1)).append('\n');
        }
        return scripts.toString();
    }

    public static String extractStyles(String html) {
        Matcher matcher = stylePattern.matcher(html);
        StringBuilder styles = new StringBuilder();
        while (matcher.find()) {
            String before = html.substring(0, matcher.start());
            String after = html.substring(matcher.end());
            if (!before.contains("<head>") || !after.contains("</head>")) continue;
            styles.append(matcher.group(1));
        }
        return styles.toString();
    }

    public static String extractMetadata(String html, String name) {
        Matcher matcher = metadataPattern.matcher(html);
        while (matcher.find()) {
            if (!matcher.group(1).equals(name)) continue;
            return matcher.group(2);
        }
        return null;
    }

    public static String extractIcon(String html) {
        Matcher matcher = iconPattern.matcher(html);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<WidgetFieldType> extractSchema(String html) {
        Document document;
        ArrayList<WidgetFieldType> schema = new ArrayList<WidgetFieldType>();
        Matcher matcher = preferencesPattern.matcher(html);
        if (!matcher.find()) {
            return schema;
        }
        html = matcher.group(0);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            dbf.setFeature("http://xml.org/sax/features/validation", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
            log.debug((Object)"Could not set DTD non-validation feature");
        }
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(html.getBytes());
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.parse(in);
        }
        catch (Exception e) {
            log.error((Object)("Could not parse widget code." + e));
            ArrayList<WidgetFieldType> arrayList = schema;
            return arrayList;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        String[] attrNames = new String[]{"label", "type", "name", "defaultValue", "min", "max", "step", "onchange"};
        NodeList nodes = document.getElementsByTagName("widget:preferences");
        if (nodes.getLength() != 1) {
            return schema;
        }
        Node node = nodes.item(0);
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node n = childNodes.item(i);
            if (n.getNodeType() != 1 || !n.getNodeName().equals("preference")) continue;
            WidgetFieldType widgetFieldType = new WidgetFieldType();
            NamedNodeMap attrs = n.getAttributes();
            Node typeAttr = attrs.getNamedItem("type");
            for (String attrName : attrNames) {
                Field field;
                Node attrNode = attrs.getNamedItem(attrName);
                if (attrNode == null) continue;
                try {
                    field = widgetFieldType.getClass().getField(attrName);
                }
                catch (Exception e) {
                    log.error((Object)("Could not access field: " + attrName + e));
                    continue;
                }
                String value = attrNode.getNodeValue();
                try {
                    field.set(widgetFieldType, value);
                }
                catch (Exception e) {
                    log.error((Object)("Could not set field: " + attrName));
                    continue;
                }
                if (typeAttr == null || !typeAttr.getNodeValue().equals("list")) continue;
                NodeList optionNodes = n.getChildNodes();
                ArrayList<WidgetFieldType.Option> options = new ArrayList<WidgetFieldType.Option>();
                for (int j = 0; j < optionNodes.getLength(); ++j) {
                    Node optionNode = optionNodes.item(j);
                    if (optionNode.getNodeType() != 1 || !optionNode.getNodeName().equals("option")) continue;
                    NamedNodeMap optionAttrs = optionNode.getAttributes();
                    Node optionLabelAttr = optionAttrs.getNamedItem("label");
                    Node optionValueAttr = optionAttrs.getNamedItem("value");
                    if (optionLabelAttr == null || optionValueAttr == null) continue;
                    WidgetFieldType widgetFieldType2 = widgetFieldType;
                    widgetFieldType2.getClass();
                    options.add(widgetFieldType2.new WidgetFieldType.Option(optionLabelAttr.getNodeValue(), optionValueAttr.getNodeValue()));
                }
                widgetFieldType.setOptions(options);
            }
            schema.add(widgetFieldType);
        }
        return schema;
    }
}

