/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.webwidgets.providers;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.CollectionOfElements;
import org.nuxeo.theme.webwidgets.Widget;
import org.nuxeo.theme.webwidgets.WidgetState;

@Entity
@Table(name="NXP_WEBW_WIDG")
@NamedQueries(value={@NamedQuery(name="Widget.removeAll", query="DELETE WidgetEntity"), @NamedQuery(name="Widget.findAll", query="FROM WidgetEntity widget WHERE widget.region=:region ORDER BY widget.order"), @NamedQuery(name="Widget.findByScope", query="FROM WidgetEntity widget WHERE widget.region=:region AND widget.scope=:scope ORDER BY widget.order")})
public class WidgetEntity
implements Widget,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int id;
    protected String uid;
    protected String name;
    protected String region;
    protected WidgetState state;
    protected int order;
    protected Map<String, String> preferences = new HashMap<String, String>();
    protected String scope;

    public WidgetEntity() {
    }

    public WidgetEntity(String name) {
        this.name = name;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="WIDGET_ID", nullable=false, columnDefinition="integer")
    public int getId() {
        return this.id;
    }

    @Override
    @Transient
    public String getUid() {
        return String.valueOf(this.id);
    }

    @Override
    @Column(name="NAME")
    public String getName() {
        return this.name;
    }

    @Column(name="REGION")
    public String getRegion() {
        return this.region;
    }

    @Column(name="ORD", columnDefinition="integer")
    public int getOrder() {
        return this.order;
    }

    @Column(name="STATE")
    public WidgetState getState() {
        return this.state;
    }

    @CollectionOfElements(fetch=FetchType.EAGER)
    @Column(name="PREFERENCES")
    public Map<String, String> getPreferences() {
        return new HashMap<String, String>(this.preferences);
    }

    @Column(name="SCOPE")
    public String getScope() {
        return this.scope;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setState(WidgetState state) {
        this.state = state;
    }

    public void setPreferences(Map<String, String> preferences) {
        this.preferences = preferences;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }
}

