/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.webwidgets.providers;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.persistence.PersistenceProvider;
import org.nuxeo.theme.webwidgets.ProviderException;
import org.nuxeo.theme.webwidgets.Widget;
import org.nuxeo.theme.webwidgets.providers.PersistentProvider;
import org.nuxeo.theme.webwidgets.providers.WidgetEntity;

public class PersistentProviderPerUser
extends PersistentProvider {
    private static final Log log = LogFactory.getLog(PersistentProviderPerUser.class);

    @Override
    public synchronized Widget createWidget(String widgetTypeName) throws ProviderException {
        if (widgetTypeName == null) {
            throw new ProviderException("Widget type name is undefined");
        }
        Principal currentNuxeoPrincipal = this.getCurrentPrincipal();
        if (currentNuxeoPrincipal == null) {
            log.warn((Object)"Could not get the current user from the context.");
            return null;
        }
        final WidgetEntity widget = new WidgetEntity(widgetTypeName);
        widget.setScope(currentNuxeoPrincipal.getName());
        try {
            this.getPersistenceProvider().run(Boolean.valueOf(true), new PersistenceProvider.RunVoid(){

                public void runWith(EntityManager em) {
                    em.persist((Object)widget);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        return widget;
    }

    @Override
    public synchronized List<Widget> getWidgets(final String regionName) throws ProviderException {
        if (regionName == null) {
            throw new ProviderException("Region name is undefined");
        }
        try {
            return (List)this.getPersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<List<Widget>>(){

                public List<Widget> runWith(EntityManager em) {
                    ArrayList<Widget> widgets = new ArrayList<Widget>();
                    Principal currentNuxeoPrincipal = PersistentProviderPerUser.this.getCurrentPrincipal();
                    if (currentNuxeoPrincipal != null) {
                        Query query = em.createNamedQuery("Widget.findByScope");
                        query.setParameter("region", (Object)regionName);
                        query.setParameter("scope", (Object)currentNuxeoPrincipal.getName());
                        widgets.addAll(query.getResultList());
                    }
                    return widgets;
                }
            });
        }
        catch (ClientException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    public boolean canRead() {
        Principal currentNuxeoPrincipal = this.getCurrentPrincipal();
        if (currentNuxeoPrincipal == null) {
            log.warn((Object)"Could not get the current user from the context.");
            return false;
        }
        return !((NuxeoPrincipal)currentNuxeoPrincipal).isAnonymous();
    }

    @Override
    public boolean canWrite() {
        Principal currentNuxeoPrincipal = this.getCurrentPrincipal();
        if (currentNuxeoPrincipal == null) {
            log.warn((Object)"Could not get the current user from the context.");
            return false;
        }
        return !((NuxeoPrincipal)currentNuxeoPrincipal).isAnonymous();
    }
}

