/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.webwidgets;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WidgetFieldType {
    public String name;
    public String type;
    public String label;
    public String defaultValue = "";
    public String min = "0";
    public String max = "1";
    public String step = "1";
    public String onchange;
    public List<Option> options;

    public String getMax() {
        return this.max;
    }

    public void setMax(String max) {
        this.max = max;
    }

    public String getMin() {
        return this.min;
    }

    public void setMin(String min) {
        this.min = min;
    }

    public String getStep() {
        return this.step;
    }

    public void setStep(String step) {
        this.step = step;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getLabel() {
        return this.label;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOnchange() {
        return this.onchange;
    }

    public void setOnchange(String onchange) {
        this.onchange = onchange;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public void setOptions(List<Option> options) {
        this.options = options;
    }

    public Map<String, Object> getInfo() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("name", this.name);
        info.put("type", this.type);
        info.put("label", this.label);
        info.put("onchange", this.onchange);
        info.put("defaultValue", this.defaultValue);
        if (this.type.equals("range")) {
            info.put("min", this.min);
            info.put("max", this.max);
            info.put("step", this.step);
        }
        if (this.type.equals("list")) {
            HashMap<String, String> optionsMap = new HashMap<String, String>();
            for (Option option : this.options) {
                optionsMap.put("label", option.getLabel());
                optionsMap.put("value", option.getValue());
            }
            info.put("options", optionsMap);
        }
        return info;
    }

    public class Option {
        private String label;
        private String value;

        public Option(String label, String value) {
            this.label = label;
            this.value = value;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

