/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center.dashboard;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.ecm.spaces.api.AbstractSpaceProvider;
import org.nuxeo.ecm.spaces.api.Space;
import org.nuxeo.ecm.spaces.api.SpaceManager;
import org.nuxeo.ecm.spaces.api.exceptions.SpaceException;
import org.nuxeo.ecm.spaces.helper.GadgetI18nHelper;
import org.nuxeo.opensocial.container.server.webcontent.api.WebContentAdapter;
import org.nuxeo.opensocial.container.shared.webcontent.OpenSocialData;
import org.nuxeo.opensocial.container.shared.webcontent.WebContentData;
import org.nuxeo.runtime.api.Framework;

public class UserDashboardSpaceProvider
extends AbstractSpaceProvider {
    public static final String DEFAULT_DASHBOARD_SPACE_PROVIDER = "defaultDashboardSpaceProvider";
    public static final String USER_DASHBOARD_SPACE_NAME = "userDashboardSpace";
    private static final Log log = LogFactory.getLog(UserDashboardSpaceProvider.class);

    protected Space doGetSpace(CoreSession session, DocumentModel contextDocument, String spaceName, Map<String, String> parameters) throws SpaceException {
        try {
            return this.getOrCreateSpace(session, parameters);
        }
        catch (ClientException e) {
            log.error((Object)"Unable to create or get personal dashboard", (Throwable)e);
            return null;
        }
    }

    protected Space getOrCreateSpace(CoreSession session, Map<String, String> parameters) throws ClientException {
        Space space;
        String userWorkspacePath = this.getUserPersonalWorkspace(session).getPathAsString();
        PathRef spaceRef = new PathRef(userWorkspacePath, USER_DASHBOARD_SPACE_NAME);
        if (session.exists((DocumentRef)spaceRef)) {
            DocumentModel existingSpace = session.getDocument((DocumentRef)spaceRef);
            return (Space)existingSpace.getAdapter(Space.class);
        }
        DefaultDashboardSpaceCopy defaultDashboardSpaceCopy = new DefaultDashboardSpaceCopy(session, parameters, userWorkspacePath);
        defaultDashboardSpaceCopy.runUnrestricted();
        if (defaultDashboardSpaceCopy.copiedSpaceRef != null && (space = (Space)session.getDocument(defaultDashboardSpaceCopy.copiedSpaceRef).getAdapter(Space.class)) != null) {
            this.i18nGadgets(space, session, parameters);
            return space;
        }
        return this.createEmptyDashboard(userWorkspacePath, session);
    }

    protected DocumentModel getUserPersonalWorkspace(CoreSession session) throws ClientException {
        try {
            UserWorkspaceService svc = (UserWorkspaceService)Framework.getService(UserWorkspaceService.class);
            return svc.getCurrentUserPersonalWorkspace(session, null);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }

    protected void i18nGadgets(Space space, CoreSession session, Map<String, String> parameters) throws ClientException {
        List webContentDatas = space.readWebContents();
        for (WebContentData data : webContentDatas) {
            Locale locale;
            String userLanguage = parameters.get("userLanguage");
            Locale locale2 = locale = userLanguage != null ? new Locale(userLanguage) : null;
            WebContentAdapter adapter = (WebContentAdapter)session.getDocument((DocumentRef)new IdRef(data.getId())).getAdapter(WebContentAdapter.class);
            if (adapter == null) continue;
            String name = data instanceof OpenSocialData ? ((OpenSocialData)data).getGadgetName() : data.getName();
            String title = GadgetI18nHelper.getI18nGadgetTitle((String)name, (Locale)locale);
            adapter.setTitle(title);
            adapter.update();
        }
        session.save();
    }

    protected Space createEmptyDashboard(String userWorkspacePath, CoreSession session) throws ClientException {
        DocumentModel model = session.createDocumentModel(userWorkspacePath, USER_DASHBOARD_SPACE_NAME, "Space");
        model.setPropertyValue("dc:title", (Serializable)((Object)"nuxeo user dashboard space"));
        model.setPropertyValue("dc:description", (Serializable)((Object)"user dashboard space"));
        model = session.createDocument(model);
        return (Space)model.getAdapter(Space.class);
    }

    public boolean isReadOnly(CoreSession session) {
        return true;
    }

    public static class DefaultDashboardSpaceCopy
    extends UnrestrictedSessionRunner {
        protected Map<String, String> parameters;
        protected String userWorkspacePath;
        public DocumentRef copiedSpaceRef;

        protected DefaultDashboardSpaceCopy(CoreSession session, Map<String, String> parameters, String userWorkspacePath) {
            super(session);
            this.parameters = parameters;
            this.userWorkspacePath = userWorkspacePath;
        }

        public void run() throws ClientException {
            SpaceManager spaceManager = this.getSpaceManager();
            Space defaultSpace = spaceManager.getSpace(UserDashboardSpaceProvider.DEFAULT_DASHBOARD_SPACE_PROVIDER, this.session, null, null, this.parameters);
            if (defaultSpace != null) {
                DocumentModel newSpace = this.session.copy((DocumentRef)new IdRef(defaultSpace.getId()), (DocumentRef)new PathRef(this.userWorkspacePath), UserDashboardSpaceProvider.USER_DASHBOARD_SPACE_NAME);
                newSpace.setPropertyValue("dc:title", (Serializable)((Object)"user dashboard space"));
                newSpace.setPropertyValue("dc:description", (Serializable)((Object)"user dashboard space"));
                ACP acp = newSpace.getACP();
                ACL acl = acp.getOrCreateACL();
                for (ACE ace : acl.getACEs()) {
                    acl.remove((Object)ace);
                }
                newSpace.setACP(acp, true);
                this.session.saveDocument(newSpace);
                this.session.save();
                this.copiedSpaceRef = newSpace.getRef();
            }
        }

        protected SpaceManager getSpaceManager() throws ClientException {
            try {
                return (SpaceManager)Framework.getService(SpaceManager.class);
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
        }
    }
}

