/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.routing;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.routing.core.impl.jsongraph.JsonGraphRoute;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="workflowModel")
@Produces(value={"application/json"})
public class WorkflowModelObject
extends DefaultObject {
    private static Log log = LogFactory.getLog(WorkflowModelObject.class);

    @GET
    public List<DocumentRoute> getWorkflowModels(@Context UriInfo uriInfo) {
        return ((DocumentRoutingService)Framework.getService(DocumentRoutingService.class)).getAvailableDocumentRouteModel(this.getContext().getCoreSession());
    }

    @GET
    @Path(value="{modelName}")
    public DocumentRoute getWorkflowModel(@PathParam(value="modelName") String modelName) {
        DocumentRoute result = ((DocumentRoutingService)Framework.getService(DocumentRoutingService.class)).getRouteModelWithId(this.getContext().getCoreSession(), modelName);
        return result;
    }

    @GET
    @Path(value="{modelName}/graph")
    public JsonGraphRoute getWorkflowModelGraph(@PathParam(value="modelName") String modelName) {
        try {
            String id = ((DocumentRoutingService)Framework.getService(DocumentRoutingService.class)).getRouteModelDocIdWithId(this.getContext().getCoreSession(), modelName);
            return new JsonGraphRoute(this.getContext().getCoreSession(), id, this.getContext().getLocale());
        }
        catch (ClientException e) {
            log.error((Object)("Can not get workflow model graph with name" + modelName));
            throw new ClientException(e);
        }
    }
}

