/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.routing.adapter;

import java.util.Arrays;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.restapi.server.jaxrs.routing.model.WorkflowRequest;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;
import org.nuxeo.runtime.api.Framework;

@WebAdapter(name="workflow", type="workflowAdapter")
public class WorkflowAdapter
extends DefaultAdapter {
    public static final String NAME = "workflow";

    @POST
    public Response doPost(WorkflowRequest routingRequest) {
        DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
        String workflowInstanceId = ((DocumentRoutingService)Framework.getLocalService(DocumentRoutingService.class)).createNewInstance(routingRequest.getWorkflowModelName(), Arrays.asList(doc.getId()), this.ctx.getCoreSession(), true);
        DocumentModel result = this.getContext().getCoreSession().getDocument((DocumentRef)new IdRef(workflowInstanceId));
        return Response.ok((Object)result).status(Response.Status.CREATED).build();
    }

    @GET
    public List<DocumentRoute> doGet() {
        DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
        return ((DocumentRoutingService)Framework.getLocalService(DocumentRoutingService.class)).getDocumentRelatedWorkflows(doc, this.getContext().getCoreSession());
    }

    @GET
    @Path(value="{workflowInstanceId}/task")
    public List<Task> doGetTasks(@PathParam(value="workflowInstanceId") String workflowInstanceId) {
        DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
        return ((DocumentRoutingService)Framework.getLocalService(DocumentRoutingService.class)).getTasks(doc, null, workflowInstanceId, null, this.getContext().getCoreSession());
    }
}

