/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.routing.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.restapi.server.jaxrs.routing.io.NodeAccessRunner;
import org.nuxeo.ecm.restapi.server.jaxrs.routing.io.util.JsonEncodeDecodeUtils;
import org.nuxeo.ecm.restapi.server.jaxrs.routing.model.TaskCompletionRequest;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.jaxrs.session.SessionFactory;

@Provider
public class TaskCompletionRequestReader
implements MessageBodyReader<TaskCompletionRequest> {
    protected static final Log log = LogFactory.getLog(TaskCompletionRequestReader.class);
    @Context
    private JsonFactory factory;
    @Context
    HttpServletRequest request;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return TaskCompletionRequest.class.isAssignableFrom(type);
    }

    public TaskCompletionRequest readFrom(Class<TaskCompletionRequest> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String content = IOUtils.toString((InputStream)entityStream);
        if (content.isEmpty() && content.isEmpty()) {
            throw new WebException("No content in request body", Response.Status.BAD_REQUEST.getStatusCode());
        }
        try {
            return this.readRequest(content, httpHeaders);
        }
        catch (IOException | ClassNotFoundException | ClientException e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    private TaskCompletionRequest readRequest(String content, MultivaluedMap<String, String> httpHeaders) throws IOException, ClientException, ClassNotFoundException {
        JsonParser jp = this.factory.createJsonParser(content);
        return this.readJson(jp, httpHeaders);
    }

    private TaskCompletionRequest readJson(JsonParser jp, MultivaluedMap<String, String> httpHeaders) throws JsonParseException, IOException, ClassNotFoundException {
        CoreSession session = SessionFactory.getSession((HttpServletRequest)this.request);
        JsonToken tok = jp.nextToken();
        if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
            tok = jp.nextToken();
        }
        String id = null;
        String comment = null;
        JsonNode variableNode = null;
        Map<String, Serializable> variables = null;
        while (tok != JsonToken.END_OBJECT) {
            String key = jp.getCurrentName();
            jp.nextToken();
            if ("id".equals(key)) {
                id = (String)jp.readValueAs(String.class);
            } else if ("comment".equals(key)) {
                comment = (String)jp.readValueAs(String.class);
            } else if ("variables".equals(key)) {
                variableNode = jp.readValueAsTree();
            } else if ("entity-type".equals(key)) {
                String entityType = (String)jp.readValueAs(String.class);
                if (!"task".equals(entityType)) {
                    throw new WebApplicationException(Response.Status.BAD_REQUEST);
                }
            } else {
                log.debug((Object)("Unknown key: " + key));
                jp.skipChildren();
            }
            tok = jp.nextToken();
        }
        if (id == null) {
            throw new WebException("No id found in request body", Response.Status.BAD_REQUEST.getStatusCode());
        }
        TaskCompletionRequest result = new TaskCompletionRequest();
        Task originalTask = (Task)session.getDocument((DocumentRef)new IdRef(id)).getAdapter(Task.class);
        String nodeId = originalTask.getVariable("nodeId");
        String workflowInstanceId = originalTask.getProcessId();
        NodeAccessRunner nodeAccessRunner = new NodeAccessRunner(session, workflowInstanceId, nodeId);
        nodeAccessRunner.runUnrestricted();
        if (variableNode != null) {
            variables = JsonEncodeDecodeUtils.decodeVariables(variableNode, nodeAccessRunner.node.getVariables(), session);
        }
        result.setVariables(variables);
        result.setComment(comment);
        return result;
    }
}

