/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.routing.io;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.automation.jaxrs.io.EntityListWriter;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.restapi.server.jaxrs.routing.io.TaskWriter;

@Provider
@Produces(value={"application/json+nxentity", "application/json"})
public class TaskListWriter
extends EntityListWriter<Task> {
    private static final Log log = LogFactory.getLog(TaskListWriter.class);
    @Context
    HttpServletRequest request;
    @Context
    UriInfo uriInfo;

    protected String getEntityType() {
        return "tasks";
    }

    protected void writeItem(JsonGenerator jg, Task item) throws ClientException, IOException {
    }

    public void writeTo(List<Task> tasks, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            JsonGenerator jg = this.factory.createJsonGenerator(entityStream, JsonEncoding.UTF8);
            jg.writeStartObject();
            jg.writeStringField("entity-type", "tasks");
            jg.writeArrayFieldStart("entries");
            for (Task docRoute : tasks) {
                jg.writeStartObject();
                jg.writeStringField("entity-type", "task");
                TaskWriter.writeTask(jg, docRoute, this.request, this.uriInfo);
                jg.writeEndObject();
            }
            jg.writeEndArray();
            jg.writeEndObject();
            jg.flush();
        }
        catch (IOException e) {
            log.error((Object)"Failed to serialize task list", (Throwable)e);
            throw new WebApplicationException(500);
        }
    }
}

