/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.web;

import java.io.Serializable;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.runtime.api.Framework;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="routeSecurityChecker")
@Install(precedence=10)
public class RouteSecurityChecker
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(required=true, create=false)
    protected NuxeoPrincipal currentUser;
    @In(required=true, create=false)
    protected CoreSession documentManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;

    @Deprecated
    public boolean canValidateRoute() {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        if (!this.documentManager.hasChildren(currentDoc.getRef())) {
            return false;
        }
        return this.getDocumentRoutingService().canUserValidateRoute(this.currentUser);
    }

    public boolean canValidateRoute(DocumentModel routeDocument) {
        return this.canValidateRoute() || this.getDocumentRoutingService().canValidateRoute(routeDocument, this.documentManager);
    }

    public DocumentRoutingService getDocumentRoutingService() {
        return (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
    }
}

