/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.sample.client;

import org.jboss.remoting.CannotConnectException;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.client.NuxeoClient;
import org.nuxeo.runtime.api.Framework;

public class Main {
    public static String host = "localhost";
    public static int port = 62474;
    public static CoreSession documentManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length == 2) {
            host = args[0];
            port = Integer.parseInt(args[1]);
        } else if (args.length != 0) {
            System.err.println("Arguments: hostname port");
            System.exit(1);
        }
        try {
            Main.connect();
        }
        catch (CannotConnectException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        try {
            Main.run();
        }
        finally {
            Main.disconnect();
        }
    }

    public static void connect() throws Exception {
        NuxeoClient.getInstance().connect(host, port);
        documentManager = ((RepositoryManager)Framework.getService(RepositoryManager.class)).getDefaultRepository().open();
    }

    public static void disconnect() {
        if (documentManager != null) {
            try {
                ((RepositoryManager)Framework.getService(RepositoryManager.class)).getDefaultRepository();
                Repository.close((CoreSession)documentManager);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            NuxeoClient.getInstance().tryDisconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void run() throws ClientException {
        DocumentModel root = documentManager.getRootDocument();
        DocumentModelList children = documentManager.getChildren(root.getRef());
        for (DocumentModel domain : children) {
            String path = domain.getPathAsString();
            String title = (String)domain.getProperty("dublincore", "title");
            System.out.println(String.format("Domain: %s (%s)", title, path));
        }
    }
}

